package cn.gtmap.hlw.core.dto.exchange.push;

import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2025/3/25
 * @description 附件项目
 */
@Data
public class PushFjxmDTO {
    /**
     * 主键
     */
    private String xmid;
    /**
     * 受理编号
     */
    private String slbh;
    /**
     * 申请id
     */
    private String sqid;
    /**
     * 材料份数
     */
    private String clfs;
    /**
     * 材料页数
     */
    private String clys;

    /**
     * 文件类型
     */
    private String wjlx;

    /**
     * 附件类型（gx_yy_zd_fj.dm或者页面生成各地区唯一附件类型代码）
     */
    private String fjlx;

    /**
     * 材料类型（字典表的FJLX）
     */
    private String cllx;
    /**
     * 附件类型名称
     */
    private String fjlxmc;

    /**
     * 是否轮播(0：否；1：是)
     */
    private String sflb;

    /**
     * 序号
     */
    private Integer xh;

    /**需推送的目标系统(zd_type表dm)英文逗号相隔*/
    private String pushsyslist;
    /**
     * 权利人类型
     */
    private String qlrlx;
    /**
     * 附件隐藏（申请类型）
     */
    private String fjyc;
    /**
     * 附件信息
     */
    private List<PushFjxxDTO> fjxxList;
    /**
     * 字典附件
     */
    private PushZdfjDTO zdfj;
}
