package cn.gtmap.hlw.core.dto.dsrw;

import cn.gtmap.hlw.core.base.BasePage;
import lombok.Data;

import java.util.Date;

/**
 * 定时任务任务动作台账响应数据
 *
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @since 2023-12-18 13:18:10
 */
@Data
public class DsrwRwddResultDTO extends BasePage {

    /**
     * 主键
     */
    private String id;

    /**
     * 定时任务id
     */
    private String dsrwid;

    /**
     * 任务名称
     */
    private String rwmc;

    /**
     * 任务开始时间
     */
    private Date rwkssj;

    /**
     * 任务结束时间
     */
    private Date rwjssj;

    /**
     * 调度状态(0：调度中，1：执行成功，2：调度失败)
     */
    private String ddzt;


    /**
     * 调度状态说明(调度失败，需要记录失败原因)
     */
    private String ddztsm;

    /**
     * 定时任务请求的接口地址
     */
    private String jkdz;

    /**
     * 接口请求方式 POST/GET
     */
    private String qqfs;

    /**
     * 是否异步执行，0：否，1：是，默认是：0
     */
    private String sfybzx;

    /**
     * 请求参数
     */
    private String qqcs;

    /**
     * 响应参数，如果是异步执行，该字段可以为空
     */
    private String xycs;

    /**
     * 执行结果（业务系统定时任务执行结果0：失败，1:成功）
     */
    private String zxjg;

    /**
     * 执行结果说明
     */
    private String zxjgsm;

    /**
     * 回调时间（异步执行时，第三方回调通知调度任务执行结果时间）
     */
    private Date hdsj;
}
