package cn.gtmap.hlw.core.domain.fj;

import cn.gtmap.hlw.core.domain.fj.model.FjEventResultModel;
import cn.gtmap.hlw.core.model.GxYyFjxx;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/7/17
 * @description
 */
public interface FjEventService {
    /**
     * 上传附件
     *
     * @param base64     文件base64字符串
     * @param sqid       申请id
     * @param fjlx       附件类型
     * @param fjmc       附件名称
     * @param slbh       受理编号
     * @param fjly       附件来源
     * @param qlrzjhList 干系人证件号
     * @return:ReturnResult
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    FjEventResultModel uploadFileFromBase64(String base64, String sqid, String fjlx, String fjmc, String slbh, String fjly, String qlrzjhList);

    /**
     * 获取附件路径
     *
     * @param fjxx
     * @return:String
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    String getFilePath(GxYyFjxx fjxx);

    /**
     * 获取base64
     *
     * @param fjxx
     * @return:String
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    String getBase64(GxYyFjxx fjxx);

    String saveFjxm(String slbh, String sqid, String fjlx);
}
