package cn.gtmap.hlw.core.constant.onething;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/11/8
 * @description 一件事常量
 */
public class OneThingConstant {
    /**
     * 一件事-集成模式：开启：推送登记后一起推一件事；关闭：实时推送一件事和单事项
     */
    public static final String YJS_JCMS_OPEN = "onething.jcms.open";

    /**
     * 单位代码-配置项-登记
     */
    public static final String ORG_DJ = "onething.org.dj";

    /**
     * 单位代码-配置项-住建
     */
    public static final String ORG_ZJ = "onething.org.zj";

    /**
     * 单位代码-配置项-税务
     */
    public static final String ORG_SW = "onething.org.sw";

    /**
     * 单位代码-配置项-水
     */
    public static final String ORG_WATER = "onething.org.water";

    /**
     * 单位代码-配置项-电
     */
    public static final String ORG_ELECTRIC = "onething.org.electric";

    /**
     * 单位代码-配置项-气
     */
    public static final String ORG_GAS = "onething.org.gas";

    /**
     * 一件事 - 预审部门
     */
    public static final String YSJ_YSBM = "onething.yjs.ysbm";

    /**
     * 一件事 - 预审人员
     */
    public static final String YSJ_YSRY = "onething.yjs.ysry";

    /**
     * 一件事 - 受理部门
     */
    public static final String YSJ_SLBM = "onething.yjs.slbm";

    /**
     * 一件事 - 受理人员
     */
    public static final String YSJ_SLRY = "onething.yjs.slry";

    /**
     * 住建 - 审批人员
     */
    public static final String ZJ_SPRY = "onething.zj.spry";

    /**
     * 税务 - 审批人员
     */
    public static final String SW_SPRY = "onething.sw.spry";

    /**
     * 删除办件 - 登记审核人员
     */
    public static final String DEL_SPRY_BDCDJ = "onething.del.spry.bdcdj";
    /**
     * 删除办件 - 住建审核人员
     */
    public static final String DEL_SPRY_ZJ = "onething.del.spry.zj";
    /**
     * 删除办件 - 税务审核人员
     */
    public static final String DEL_SPRY_SW = "onething.del.spry.sw";
    /**
     * 删除办件 - 水审核人员
     */
    public static final String DEL_SPRY_WATER = "onething.del.spry.water";
    /**
     * 删除办件 - 电审核人员
     */
    public static final String DEL_SPRY_ELECTRIC = "onething.del.spry.electric";
    /**
     * 删除办件 - 气审核人员
     */
    public static final String DEL_SPRY_GAS = "onething.del.spry.gas";


    /**
     * 申请方式
     */
    public static final String APPLYWAY = "10";

    /**
     *一件事办件状态
     */
    public static final String YJSSTATUS = "20";

    /**
     * 申请人类型 - 个人
     */
    public static final String APPLYERTYPE_GR = "01";

    /**
     * 申请人类型 - 企业
     */
    public static final String APPLYERTYPE_QY = "02";

    /**
     * 预审结果 - 预审通过
     */
    public static final String RESULT_TG = "1";

    /**
     * 预审结果 - 预审不通过
     */
    public static final String RESULT_BTG = "2";

    /**
     * 办件形式 - 申请
     */
    public static final String SQ_WAY = "2";

    /**
     * 办件状态
     */
    public static final String BJ_STATU = "Y";

    /**
     * 办件类型
     */
    public static final String APPLY_TYPE = "2";

    /**
     * 数据来源 - 登记单事项
     */
    public static final String DATA_SOURCES_DJ = "1";

    /**
     * 数据来源 - 其他单事项
     */
    public static final String DATA_SOURCES_QT = "2";

    /**
     * 事项类型 - 行政权力
     */
    public static final String QL_KIND_XZQL = "1";

    /**
     * 事项类型 - 公共服务
     */
    public static final String QL_KIND_GGFW = "2";
}
