/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.string;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicUtil {
    private static final Logger log = LoggerFactory.getLogger(PublicUtil.class);

    public static <T> List<T> getBeanListByJsonArray(Object obj, Class<T> tClass) {
        List t = null;
        try {
            t = obj instanceof String ? JSON.parseArray((String)obj.toString(), tClass) : JSON.parseArray((String)JSON.toJSONString((Object)obj), tClass);
        }
        catch (Exception e) {
            log.error("getBeanListByJsonArray:" + e.getMessage());
        }
        return t;
    }

    public static <T> T getBeanByJsonObj(Object json, Class<T> tClass) {
        Object t = null;
        try {
            t = json instanceof String ? JSON.parseObject((String)json.toString(), tClass) : JSON.parseObject((String)JSON.toJSONString((Object)json), tClass);
        }
        catch (Exception e) {
            log.error("getBeanByJsonObj:" + e.getMessage());
        }
        return (T)t;
    }

    public static String getUserNameByLxdh(String lxdh) {
        String userName = null;
        if (StringUtils.isNotBlank((CharSequence)lxdh)) {
            userName = "yhm" + lxdh.substring(lxdh.length() - 4, lxdh.length()) + RandomStringUtils.randomNumeric((int)6);
        }
        return userName;
    }

    public static boolean compareString(String target, List<String> source) {
        if (StringUtils.isNotBlank((CharSequence)target) && source.size() > 0) {
            for (String compare : source) {
                if (!StringUtils.equals((CharSequence)compare, (CharSequence)target)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean hasAnyFieldNotNull(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u80fd\u4e3a null");
        }
        Class<?> clazz = entity.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || field.getType().isPrimitive()) continue;
            field.setAccessible(true);
            try {
                Object value = field.get(entity);
                if (value == null) continue;
                return true;
            }
            catch (IllegalAccessException e) {
                System.err.println("\u65e0\u6cd5\u8bbf\u95ee\u5b57\u6bb5 " + field.getName() + ": " + e.getMessage());
            }
        }
        return false;
    }
}

