/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.file;

import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.exception.IError;
import cn.gtmap.hlw.core.util.date.DateUtils;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.gtis.config.AppConfig;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.multipart.MultipartFile;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);
    private static final int BUFFER_SIZE = 0x100000;

    public static File uploadFile(String uploadFilePath, String fileName, byte[] file) {
        if (StringUtils.isNotBlank((CharSequence)uploadFilePath)) {
            FileUtil.mkdir((String)uploadFilePath);
            return FileUtil.writeBytes((byte[])file, (String)(uploadFilePath + File.separator + fileName));
        }
        return null;
    }

    public static void uploadBase64File(String uploadFilePath, String fileName, String base64Str) {
        base64Str = base64Str.replace("data:image/jpeg;base64,", "").replace("data:image/png;base64,", "").replace("data:image/gif;base64,", "").replace("data:image/jpg;base64,", "").replace("data:image/png;base64,", "");
        try {
            byte[] bytes = Base64.getDecoder().decode(base64Str);
            FileUtils.uploadFile(uploadFilePath, fileName, bytes);
        }
        catch (Exception e) {
            logger.error("uploadBase64File  ERROR\uff1a{}", (Object)e.getMessage());
            throw new BizException((IError)ErrorEnum.SERVICE_ERROR, "\u4e0a\u4f20base64\u5b57\u7b26\u4e32\u6587\u4ef6\u5230\u6307\u5b9a\u8def\u5f84\u51fa\u73b0\u5f02\u5e38");
        }
    }

    public static String getFjBase64(String filepath, String fjmc) {
        byte[] fileContent;
        File file;
        if (StringUtils.isNotBlank((CharSequence)fjmc)) {
            filepath = filepath + "\\" + fjmc;
        }
        if (!(file = new File(filepath)).exists()) {
            return "";
        }
        try {
            fileContent = FileUtils.readBytes(file);
        }
        catch (IOException e) {
            throw new BizException((IError)ErrorEnum.SERVICE_ERROR, "\u67e5\u770b\u9644\u4ef6\u4fe1\u606f\u5f02\u5e38");
        }
        String base64String = Base64.getEncoder().encodeToString(fileContent);
        base64String = base64String.replaceAll("data/image/png/base64/", "");
        return base64String;
    }

    public static String getMimeType(String filePath) {
        String mimeType = FileUtil.getMimeType((String)filePath);
        if (StringUtils.isBlank((CharSequence)mimeType)) {
            if (StrUtil.endWithIgnoreCase((CharSequence)filePath, (CharSequence)".pdf")) {
                mimeType = "application/pdf";
            } else if (StrUtil.endWithIgnoreCase((CharSequence)filePath, (CharSequence)".ofd")) {
                mimeType = "application/ofd";
            } else if (StrUtil.endWithIgnoreCase((CharSequence)filePath, (CharSequence)".jpeg")) {
                mimeType = "image/jpeg";
            } else if (StrUtil.endWithIgnoreCase((CharSequence)filePath, (CharSequence)".jpg")) {
                mimeType = "image/jpeg";
            } else if (StrUtil.endWithIgnoreCase((CharSequence)filePath, (CharSequence)".png")) {
                mimeType = "image/png";
            } else if (StrUtil.endWithIgnoreCase((CharSequence)filePath, (CharSequence)".gif")) {
                mimeType = "image/gif";
            }
        }
        return mimeType;
    }

    public static String getFilePath(String uploadPath, String slbh, String xmid, String fjid) {
        StringBuilder sb = new StringBuilder();
        String dateToStr = DateUtils.dateToStr(new Date(), DateUtils.DATE_FORMAT_FILE);
        sb.append(uploadPath).append(File.separatorChar).append(dateToStr).append(File.separatorChar).append(slbh).append(File.separatorChar).append(xmid).append(File.separator).append(fjid);
        return sb.toString();
    }

    public static MultipartFile getMultipartFile(File file) throws RuntimeException {
        FileInputStream inputStream = null;
        MockMultipartFile multipartFile = null;
        try {
            inputStream = new FileInputStream(file);
            multipartFile = new MockMultipartFile(file.getName(), file.getName(), Files.probeContentType(file.toPath()), (InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error("\u6587\u4ef6\u6d41\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        return multipartFile;
    }

    public static byte[] convertToByteArray(InputStream inputStream) throws IOException {
        int bytesRead;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
        inputStream.close();
        return outputStream.toByteArray();
    }

    public static String byteToBase64(byte[] byteArray) {
        return Base64.getEncoder().encodeToString(byteArray);
    }

    public static String encodeToBase64(InputStream inputStream) throws IOException {
        int count;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((count = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, count);
        }
        byte[] byteArray = outputStream.toByteArray();
        String base64String = Base64.getEncoder().encodeToString(byteArray);
        outputStream.close();
        return base64String;
    }

    public static MultipartFile convertMultipartFile(String base64String, String fileName) {
        byte[] imageBytes = Base64.getDecoder().decode(base64String);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(imageBytes);
        MockMultipartFile multipartFile = null;
        try {
            multipartFile = new MockMultipartFile(fileName, fileName, "application/pdf", (InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return multipartFile;
    }

    /*
     * Exception decompiling
     */
    public static byte[] images2pdf(File[] files) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return "";
        }
        int lastDotIndex = fileName.lastIndexOf(".");
        if (lastDotIndex == -1 || lastDotIndex == fileName.length() - 1) {
            return "";
        }
        return fileName.substring(lastDotIndex + 1);
    }

    public static boolean renameFile(String filePath, String newName) {
        File oldFile = new File(filePath);
        if (!oldFile.exists()) {
            return false;
        }
        String parentDir = oldFile.getParent();
        String fileExtension = FileUtils.getFileExtension(oldFile.getName());
        String newFilePath = parentDir + File.separator + newName + "." + fileExtension;
        File newFile = new File(newFilePath);
        return oldFile.renameTo(newFile);
    }

    public static String MultipartFileToString(MultipartFile multipartFile) {
        StringBuilder txtResult = new StringBuilder();
        try {
            String lineTxt;
            InputStreamReader isr = new InputStreamReader(multipartFile.getInputStream(), StandardCharsets.UTF_8);
            BufferedReader br = new BufferedReader(isr);
            while ((lineTxt = br.readLine()) != null) {
                txtResult.append(lineTxt);
            }
            isr.close();
            br.close();
            return txtResult.toString();
        }
        catch (IOException e) {
            logger.error("MultipartFileToString", (Throwable)e);
            return "";
        }
    }

    public static byte[] image2byte(String path) {
        byte[] data = null;
        try (FileInputStream input = new FileInputStream(path);
             ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int numBytesRead;
            byte[] buf = new byte[8192];
            while ((numBytesRead = input.read(buf)) != -1) {
                output.write(buf, 0, numBytesRead);
            }
            data = output.toByteArray();
        }
        catch (IOException e) {
            logger.error("image2byte", (Throwable)e);
        }
        return data;
    }

    public static File base64ToFile(String base64Str) {
        File outputFile;
        logger.info("base64\u5206\u5757\u8f6c\u6362\u5f00\u59cb\uff0c\u65f6\u95f4\uff1a{}", (Object)DateUtils.dateToStr(new Date()));
        try {
            outputFile = File.createTempFile("temp", ".zip");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (FileOutputStream fos = new FileOutputStream(outputFile);){
            int length = base64Str.length();
            int offset = 0;
            while (offset < length) {
                int end = Math.min(offset + 0x100000, length);
                String base64Chunk = base64Str.substring(offset, end);
                byte[] dataChunk = Base64.getDecoder().decode(base64Chunk);
                fos.write(dataChunk);
                offset = end;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        logger.info("base64\u5206\u5757\u8f6c\u6362\u7ed3\u675f\uff0c\u65f6\u95f4\uff1a{}", (Object)DateUtils.dateToStr(new Date()));
        return outputFile;
    }

    public static byte[] getCombinePdf(List<byte[]> bytes) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document();
        try {
            PdfCopy copy = new PdfCopy(document, (OutputStream)byteArrayOutputStream);
            document.open();
            for (byte[] bs : bytes) {
                PdfReader reader = new PdfReader(bs);
                int pageTotal = reader.getNumberOfPages();
                for (int pageNo = 1; pageNo <= pageTotal; ++pageNo) {
                    document.newPage();
                    PdfImportedPage page = copy.getImportedPage(reader, pageNo);
                    copy.addPage(page);
                }
                reader.close();
            }
            document.close();
            byte[] pdfs = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            copy.close();
            return pdfs;
        }
        catch (Exception e) {
            logger.error("pdf\u6587\u4ef6\u5408\u5e76\u5931\u8d25, \u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hbpdf(List<String> pdfFiles) {
        Document document = null;
        FileOutputStream fileOutputStream = null;
        PdfReader pdfReader = null;
        String filePath = StringUtils.replace((String)pdfFiles.get(0), (String)".pdf", (String)"1.pdf");
        try {
            pdfReader = new PdfReader(pdfFiles.get(0));
            document = new Document(pdfReader.getPageSize(1));
            fileOutputStream = new FileOutputStream(filePath);
            PdfCopy copy = new PdfCopy(document, (OutputStream)fileOutputStream);
            document.open();
            for (String pdfFile : pdfFiles) {
                PdfReader reader = new PdfReader(pdfFile);
                for (int i = 1; i <= reader.getNumberOfPages(); ++i) {
                    document.newPage();
                    copy.addPage(copy.getImportedPage(reader, i));
                }
                reader.close();
            }
            copy.close();
        }
        catch (Exception copy) {
        }
        finally {
            if (null != pdfReader) {
                pdfReader.close();
            }
            if (null != document) {
                document.close();
            }
            if (null != fileOutputStream) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException copy) {}
            }
        }
        try {
            FileUtils.copyFile(new File(filePath), new File(pdfFiles.get(0)));
            boolean delete = new File(filePath).delete();
            if (!delete) {
                logger.info("Failed to delete file: " + filePath);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void copyFile(File source, File target) throws IOException {
        try (FileInputStream in = new FileInputStream(source);
             FileOutputStream out = new FileOutputStream(target);){
            int length;
            byte[] buffer = new byte[8192];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
        }
    }

    public static String mergePdfs(List<String> base64Pdfs) throws IOException {
        PDFMergerUtility mergerUtility = new PDFMergerUtility();
        for (String base64Pdf : base64Pdfs) {
            byte[] pdfBytes = Base64.getDecoder().decode(base64Pdf);
            PDDocument document = PDDocument.load((InputStream)new ByteArrayInputStream(pdfBytes));
            Throwable throwable = null;
            try {
                mergerUtility.addSource((InputStream)new ByteArrayInputStream(pdfBytes));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (document == null) continue;
                if (throwable != null) {
                    try {
                        document.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                document.close();
            }
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            mergerUtility.setDestinationStream((OutputStream)outputStream);
            mergerUtility.mergeDocuments(null);
            byte[] mergedPdfBytes = outputStream.toByteArray();
            String string = Base64.getEncoder().encodeToString(mergedPdfBytes);
            return string;
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] readBytes(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] base64ToByte(String base64Str) {
        if (base64Str == null || base64Str.isEmpty()) {
            return new byte[0];
        }
        if (base64Str.contains(",")) {
            base64Str = base64Str.substring(base64Str.indexOf(",") + 1);
        }
        return Base64.getDecoder().decode(base64Str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decoderByteFile(byte[] bytes, String targetPath, String catalogue) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        if (StringUtils.isNotBlank((CharSequence)catalogue) && catalogue.contains(".pdf")) {
            catalogue = catalogue.substring(0, catalogue.lastIndexOf(".pdf"));
        }
        File file = null;
        boolean pdf = targetPath.endsWith(".pdf") && AppConfig.getBooleanProperty((String)"whole.writetopdf.rename", (boolean)false);
        String tempPath = null;
        try {
            File fileF = new File(targetPath);
            if (fileF.exists()) {
                fileF.delete();
            }
            if (pdf) {
                tempPath = targetPath.substring(0, targetPath.lastIndexOf(".pdf")) + ".txt";
                File dir = new File(catalogue);
                if (!dir.exists() && !dir.isDirectory()) {
                    dir.mkdirs();
                }
                if ((file = new File(tempPath)).exists()) {
                    file.delete();
                }
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                bos.write(bytes);
            } else {
                File dir = new File(catalogue);
                if (!dir.exists() && !dir.isDirectory()) {
                    dir.mkdirs();
                }
                file = new File(targetPath);
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                bos.write(bytes);
            }
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4fdd\u5b58\u51fa\u9519{}", (Object)e.getMessage());
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    logger.error("IO\u5173\u95ed\u5f02\u5e38{}", (Object)e.getMessage());
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error("IO\u5173\u95ed\u5f02\u5e38{}", (Object)e.getMessage());
                }
            }
        }
        if (pdf) {
            File empFile = new File(tempPath);
            empFile.renameTo(new File(targetPath));
            empFile.deleteOnExit();
        }
    }
}

