/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.encryption;

import cn.gtmap.hlw.core.dto.util.EncryptDTO;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM4Engine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigitalEnvelopeUtil {
    private static final Logger log = LoggerFactory.getLogger(DigitalEnvelopeUtil.class);
    private static final Logger logger = LoggerFactory.getLogger(DigitalEnvelopeUtil.class);
    public static final BouncyCastleProvider BOUNCY_CASTLE_PROVIDER = new BouncyCastleProvider();
    public static final String SM2_CURVES_NAME = "sm2p256v1";
    public static final String RSA_ALGORITHM = "RSA";
    public static final String SM2_ALGORITHM = "SM2";
    public static final String EC_ALGORITHM = "EC";
    public static final String SM4_ALGORITHM = "SM4";
    public static final String BC_ALGORITHM = "BC";
    public static final String SIGN_ALGORITHM = "SM3withSM2";
    public static final String UTF8_CHARSET = "UTF-8";
    private static String publicKey = "BGrWk/fz/kYymZo7ib24jTkQqf9Xn27TL6krnJTEVTBztikVBsPiMNQnwii4oQUUy81lHw8UAJLjctqPOlcgWKg=";
    private static String privateKey = "AN3OfV2Ujba3+EnhRCf2+Tr9b/3KgbpB+GUVLtTJz2Hg";
    private static String myPublicKey = "BOWt12afqs8adQxRoacrJfHt/my4HCxj5b3nTGS6t1sKwULaXpNM5oXDBe3CIImVJ1YqabRaO8NkYlICnONLmFo=";
    private static String myPrivateKey = "AKWFcc+nljrpGTcNnzJEQ5AvvOvT7u+wHf2aNbV+8+8g";

    private static KeyPair generateSm2KeyPair() throws Exception {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(EC_ALGORITHM, BC_ALGORITHM);
            ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)SM2_CURVES_NAME);
            keyPairGenerator.initialize((AlgorithmParameterSpec)ecSpec);
            return keyPairGenerator.generateKeyPair();
        }
        catch (Exception e) {
            logger.error("\u751f\u6210SM2\u5bc6\u94a5\u5bf9\u5931\u8d25", (Throwable)e);
            throw new Exception("\u751f\u6210SM2\u5bc6\u94a5\u5bf9\u5931\u8d25", e);
        }
    }

    private static byte[] signWithSm3(String data, PrivateKey privateKey) throws Exception {
        try {
            Signature signature = Signature.getInstance(SIGN_ALGORITHM, BC_ALGORITHM);
            signature.initSign(privateKey);
            signature.update(data.getBytes());
            return signature.sign();
        }
        catch (Exception e) {
            logger.error("\u4f7f\u7528SM3\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            throw new Exception("\u4f7f\u7528SM3\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    private static boolean verifyWithSm3(String input, byte[] signature, PublicKey publicKey) throws Exception {
        try {
            Signature signature2 = Signature.getInstance(SIGN_ALGORITHM, BC_ALGORITHM);
            signature2.initVerify(publicKey);
            signature2.update(input.getBytes());
            return signature2.verify(signature);
        }
        catch (Exception e) {
            logger.error("\u4f7f\u7528SM3\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            throw new Exception("\u4f7f\u7528SM3\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    private static String encryptWithSm4(String plainText, byte[] key, byte[] iv) throws Exception {
        try {
            SM4Engine engine = new SM4Engine();
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)engine));
            cipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(key), iv));
            byte[] input = plainText.getBytes(UTF8_CHARSET);
            byte[] output = new byte[cipher.getOutputSize(input.length)];
            int len = cipher.processBytes(input, 0, input.length, output, 0);
            cipher.doFinal(output, len);
            return Hex.toHexString((byte[])output);
        }
        catch (Exception e) {
            logger.error("SM4\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            throw new Exception("SM4\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    private static String decryptWithSm4(String cipherText, byte[] key, byte[] iv) throws Exception {
        try {
            SM4Engine engine = new SM4Engine();
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)engine));
            cipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(key), iv));
            byte[] input = Hex.decode((String)cipherText);
            byte[] output = new byte[cipher.getOutputSize(input.length)];
            int len = cipher.processBytes(input, 0, input.length, output, 0);
            cipher.doFinal(output, len);
            if (output != null && output.length != 0) {
                for (int i = output.length - 1; i >= 0; --i) {
                    if (output[i] == 0) continue;
                    output = Arrays.copyOfRange(output, 0, i + 1);
                    break;
                }
            }
            return new String(output, UTF8_CHARSET).trim();
        }
        catch (Exception e) {
            logger.error("SM4\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
            throw new Exception("SM4\u89e3\u5bc6\u5931\u8d25", e);
        }
    }

    private static byte[] generateKey() throws Exception {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(SM4_ALGORITHM, BC_ALGORITHM);
            keyGenerator.init(128, new SecureRandom());
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (Exception e) {
            logger.error("\u751f\u6210SM4\u5bc6\u94a5\u5931\u8d25", (Throwable)e);
            throw new Exception("\u751f\u6210SM4\u5bc6\u94a5\u5931\u8d25", e);
        }
    }

    private static byte[] generateIV() throws Exception {
        try {
            byte[] iv = new byte[16];
            new SecureRandom().nextBytes(iv);
            return iv;
        }
        catch (Exception e) {
            logger.error("\u751f\u6210IV\u5931\u8d25", (Throwable)e);
            throw new Exception("\u751f\u6210IV\u5931\u8d25", e);
        }
    }

    public static PublicKey generatePublicKeyByKeyValue(String algorithm, KeySpec keySpec) {
        try {
            return KeyFactory.getInstance(algorithm, (Provider)BOUNCY_CASTLE_PROVIDER).generatePublic(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u5bc6\u94a5\u89c4\u8303: " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5: " + algorithm, e);
        }
    }

    public static PrivateKey generatePrivateKeyByKeyValue(String algorithm, KeySpec keySpec) {
        try {
            return KeyFactory.getInstance(algorithm, (Provider)BOUNCY_CASTLE_PROVIDER).generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u5bc6\u94a5\u89c4\u8303: " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5: " + algorithm, e);
        }
    }

    private static Cipher getCipherInstance(String transformations) {
        try {
            return Cipher.getInstance(transformations, (Provider)BOUNCY_CASTLE_PROVIDER);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5 ", e);
        }
        catch (NoSuchPaddingException e) {
            throw new IllegalArgumentException("\u586b\u5145\u9519\u8bef", e);
        }
    }

    public static byte[] asymmetricKeyEncrypt(byte[] publicKeyValue, String keyAlgorithm, byte[] message) {
        PublicKey publicKey;
        String algorithm = EC_ALGORITHM.equalsIgnoreCase(keyAlgorithm) ? SM2_ALGORITHM : keyAlgorithm;
        if (SM2_ALGORITHM.equalsIgnoreCase(algorithm)) {
            ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)SM2_CURVES_NAME);
            ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(spec.getCurve().decodePoint(publicKeyValue), (ECParameterSpec)spec);
            publicKey = DigitalEnvelopeUtil.generatePublicKeyByKeyValue(EC_ALGORITHM, (KeySpec)ecPublicKeySpec);
        } else if (RSA_ALGORITHM.equalsIgnoreCase(algorithm)) {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKeyValue);
            publicKey = DigitalEnvelopeUtil.generatePublicKeyByKeyValue(RSA_ALGORITHM, x509EncodedKeySpec);
        } else {
            throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), String.format("not support algorithm  %s", keyAlgorithm));
        }
        Cipher cipher = DigitalEnvelopeUtil.getCipherInstance(algorithm);
        return DigitalEnvelopeUtil.encryptForAsymmetric(cipher, publicKey, message);
    }

    public static byte[] asymmetricKeyDecrypt(byte[] privateKeyValue, String keyAlgorithm, byte[] cipherText) {
        PrivateKey privateKey;
        String algorithm = EC_ALGORITHM.equalsIgnoreCase(keyAlgorithm) ? SM2_ALGORITHM : keyAlgorithm;
        if (SM2_ALGORITHM.equalsIgnoreCase(algorithm)) {
            ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)SM2_CURVES_NAME);
            ECPrivateKeySpec ecPrivateKeySpec = new ECPrivateKeySpec(new BigInteger(1, privateKeyValue), (ECParameterSpec)spec);
            privateKey = DigitalEnvelopeUtil.generatePrivateKeyByKeyValue(EC_ALGORITHM, (KeySpec)ecPrivateKeySpec);
        } else if (RSA_ALGORITHM.equalsIgnoreCase(algorithm)) {
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKeyValue);
            privateKey = DigitalEnvelopeUtil.generatePrivateKeyByKeyValue(RSA_ALGORITHM, pkcs8EncodedKeySpec);
        } else {
            throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), String.format("not support algorithm  %s", keyAlgorithm));
        }
        Cipher cipher = DigitalEnvelopeUtil.getCipherInstance(algorithm);
        return DigitalEnvelopeUtil.decryptForAsymmetric(cipher, privateKey, cipherText);
    }

    private static byte[] encryptForAsymmetric(Cipher cipher, Key key, byte[] message) {
        try {
            cipher.init(1, key);
            return cipher.doFinal(message);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("\u79d8\u94a5\u5f02\u5e38\uff01 ", e);
        }
        catch (BadPaddingException e) {
            throw new IllegalArgumentException("\u586b\u5145\u6570\u636e\u9519\u8bef\uff01 ", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalArgumentException("\u975e\u6cd5\u533a\u5757\u5927\u5c0f\u5f02\u5e38\uff01 ", e);
        }
    }

    private static byte[] decryptForAsymmetric(Cipher cipher, Key key, byte[] cipherText) {
        try {
            cipher.init(2, key);
            return cipher.doFinal(cipherText);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("\u79d8\u94a5\u5f02\u5e38\uff01 ", e);
        }
        catch (BadPaddingException e) {
            throw new IllegalArgumentException("\u586b\u5145\u6570\u636e\u9519\u8bef\uff01 ", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalArgumentException("\u975e\u6cd5\u533a\u5757\u5927\u5c0f\u5f02\u5e38\uff01 ", e);
        }
    }

    public static EncryptDTO encryptData(String jsonString, String platformPublicKey, String platformPrivateKey, String thirdPartyPublicKey) throws Exception {
        KeyPair keyPair = DigitalEnvelopeUtil.buildKeyPairFromBase64(platformPrivateKey, platformPublicKey);
        PrivateKey signPrivateKey = keyPair.getPrivate();
        PublicKey signPublicKey = keyPair.getPublic();
        byte[] bytes = DigitalEnvelopeUtil.signWithSm3(jsonString, signPrivateKey);
        byte[] sm4Key = DigitalEnvelopeUtil.generateKey();
        byte[] iv = DigitalEnvelopeUtil.generateIV();
        String encryptedData = DigitalEnvelopeUtil.encryptWithSm4(jsonString, sm4Key, iv);
        byte[] encryptionSm4Key = DigitalEnvelopeUtil.asymmetricKeyEncrypt(Base64.getDecoder().decode(thirdPartyPublicKey), SM2_ALGORITHM, sm4Key);
        EncryptDTO encryptDTO = new EncryptDTO();
        encryptDTO.setEncryptData(encryptionSm4Key);
        encryptDTO.setSm4CipherText(encryptedData);
        encryptDTO.setIv(iv);
        encryptDTO.setSignaData(bytes);
        encryptDTO.setPlatformPublicKey(Base64.getEncoder().encodeToString(signPublicKey.getEncoded()));
        return encryptDTO;
    }

    public static String decDate(EncryptDTO encryptDTO, String thirdPartyPrivateKey) throws Exception {
        log.info("thirdPartyPrivateKey:" + thirdPartyPrivateKey);
        byte[] encryptData = encryptDTO.getEncryptData();
        byte[] iv = encryptDTO.getIv();
        String sm4CipherText = encryptDTO.getSm4CipherText();
        byte[] signaData = encryptDTO.getSignaData();
        PublicKey publicKey = null;
        try {
            byte[] publicKeyBytes = Base64.getDecoder().decode(encryptDTO.getPlatformPublicKey());
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(EC_ALGORITHM, BC_ALGORITHM);
            publicKey = keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            logger.warn("X.509\u516c\u94a5\u89e3\u6790\u5931\u8d25\uff0c\u5c1d\u8bd5\u5176\u4ed6\u65b9\u5f0f: " + e.getMessage());
            try {
                byte[] firstDecoded = Base64.getDecoder().decode(encryptDTO.getPlatformPublicKey());
                String realPublicKeyStr = new String(firstDecoded, UTF8_CHARSET);
                byte[] publicKeyBytes = Base64.getDecoder().decode(realPublicKeyStr);
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
                KeyFactory keyFactory = KeyFactory.getInstance(EC_ALGORITHM, BC_ALGORITHM);
                publicKey = keyFactory.generatePublic(keySpec);
            }
            catch (Exception ex) {
                logger.warn("\u53cc\u91cdBase64\u89e3\u6790\u4e5f\u5931\u8d25\uff0c\u5c1d\u8bd5\u4f5c\u4e3aEC\u70b9\u5750\u6807\u5904\u7406: " + ex.getMessage());
                try {
                    byte[] publicKeyBytes = Base64.getDecoder().decode(encryptDTO.getPlatformPublicKey());
                    ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)SM2_CURVES_NAME);
                    ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(spec.getCurve().decodePoint(publicKeyBytes), (ECParameterSpec)spec);
                    KeyFactory keyFactory = KeyFactory.getInstance(EC_ALGORITHM, BC_ALGORITHM);
                    publicKey = keyFactory.generatePublic((KeySpec)ecPublicKeySpec);
                }
                catch (Exception ex2) {
                    throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790\u516c\u94a5\u683c\u5f0f", ex2);
                }
            }
        }
        byte[] deserializeSm4Key = DigitalEnvelopeUtil.asymmetricKeyDecrypt(Base64.getDecoder().decode(thirdPartyPrivateKey), SM2_ALGORITHM, encryptData);
        String decryptedText = DigitalEnvelopeUtil.decryptWithSm4(sm4CipherText, deserializeSm4Key, iv);
        boolean isCorrect = DigitalEnvelopeUtil.verifyWithSm3(decryptedText, signaData, publicKey);
        System.out.println("\u9a8c\u8bc1\u7b7e\u540d\uff1a" + isCorrect);
        if (isCorrect) {
            return decryptedText;
        }
        return null;
    }

    public static void main1(String[] args) throws Exception {
        String s = "BOWt12afqs8adQxRoacrJfHt/my4HCxj5b3nTGS6t1sKwULaXpNM5oXDBe3CIImVJ1YqabRaO8NkYlICnONLmFo=";
        PublicKey publicKey = null;
        try {
            byte[] publicKeyBytes = Base64.getDecoder().decode(s);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(EC_ALGORITHM, BC_ALGORITHM);
            publicKey = keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            logger.warn("X.509\u516c\u94a5\u89e3\u6790\u5931\u8d25\uff0c\u5c1d\u8bd5\u5176\u4ed6\u65b9\u5f0f: " + e.getMessage());
            try {
                byte[] firstDecoded = Base64.getDecoder().decode(s);
                String realPublicKeyStr = new String(firstDecoded, UTF8_CHARSET);
                byte[] publicKeyBytes = Base64.getDecoder().decode(realPublicKeyStr);
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
                KeyFactory keyFactory = KeyFactory.getInstance(EC_ALGORITHM, BC_ALGORITHM);
                publicKey = keyFactory.generatePublic(keySpec);
            }
            catch (Exception ex) {
                logger.warn("\u53cc\u91cdBase64\u89e3\u6790\u4e5f\u5931\u8d25\uff0c\u5c1d\u8bd5\u4f5c\u4e3aEC\u70b9\u5750\u6807\u5904\u7406: " + ex.getMessage());
                try {
                    byte[] publicKeyBytes = Base64.getDecoder().decode(s);
                    ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)SM2_CURVES_NAME);
                    ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(spec.getCurve().decodePoint(publicKeyBytes), (ECParameterSpec)spec);
                    KeyFactory keyFactory = KeyFactory.getInstance(EC_ALGORITHM, BC_ALGORITHM);
                    publicKey = keyFactory.generatePublic((KeySpec)ecPublicKeySpec);
                }
                catch (Exception ex2) {
                    throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790\u516c\u94a5\u683c\u5f0f", ex2);
                }
            }
        }
    }

    private static KeyPair buildKeyPairFromBase64(String base64PrivateKey, String base64PublicKey) throws Exception {
        try {
            byte[] privateKeyBytes = Base64.getDecoder().decode(base64PrivateKey);
            byte[] publicKeyBytes = Base64.getDecoder().decode(base64PublicKey);
            ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)SM2_CURVES_NAME);
            ECPrivateKeySpec ecPrivateKeySpec = new ECPrivateKeySpec(new BigInteger(1, privateKeyBytes), (ECParameterSpec)spec);
            PrivateKey privateKey = KeyFactory.getInstance(EC_ALGORITHM, BC_ALGORITHM).generatePrivate((KeySpec)ecPrivateKeySpec);
            ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(spec.getCurve().decodePoint(publicKeyBytes), (ECParameterSpec)spec);
            PublicKey publicKey = KeyFactory.getInstance(EC_ALGORITHM, BC_ALGORITHM).generatePublic((KeySpec)ecPublicKeySpec);
            return new KeyPair(publicKey, privateKey);
        }
        catch (Exception e) {
            logger.error("\u6784\u5efa\u5bc6\u94a5\u5bf9\u5931\u8d25: base64PrivateKey={}, base64PublicKey={}", new Object[]{base64PrivateKey, base64PublicKey, e});
            throw new Exception("\u6784\u5efa\u5bc6\u94a5\u5bf9\u5931\u8d25", e);
        }
    }

    private static void getMyKeys() throws Exception {
        KeyPair keyPair = DigitalEnvelopeUtil.generateSm2KeyPair();
        ECPublicKey ecPublicKey = (ECPublicKey)keyPair.getPublic();
        ECPoint publicKeyPoint = ecPublicKey.getQ();
        byte[] publicKeyBytes = publicKeyPoint.getEncoded(false);
        ECPrivateKey ecPrivateKey = (ECPrivateKey)keyPair.getPrivate();
        BigInteger privateKeyD = ecPrivateKey.getS();
        byte[] privateKeyBytes = privateKeyD.toByteArray();
        String base64PublicKey = Base64.getEncoder().encodeToString(publicKeyBytes);
        String base64PrivateKey = Base64.getEncoder().encodeToString(privateKeyBytes);
        System.out.println("\u539f\u59cb\u683c\u5f0f\u516c\u94a5(\u7528\u4e8e\u52a0\u5bc6): " + base64PublicKey);
        System.out.println("\u539f\u59cb\u683c\u5f0f\u79c1\u94a5(\u7528\u4e8e\u89e3\u5bc6): " + base64PrivateKey);
        try {
            ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)SM2_CURVES_NAME);
            ECPoint decodedPoint = spec.getCurve().decodePoint(publicKeyBytes);
            System.out.println("\u516c\u94a5\u70b9\u89e3\u7801\u6210\u529f: " + decodedPoint);
        }
        catch (Exception e) {
            System.err.println("\u516c\u94a5\u70b9\u89e3\u7801\u5931\u8d25: " + e.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        DigitalEnvelopeUtil.getMyKeys();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

