package cn.gtmap.hlw.coredk.dto.exchange;

import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.coredk.enums.error.ExchangeErrorEnum;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/7/27
 * @description
 */
@Data
public class ResExchangeDTO<T> {
    /**
     * 请求头
     */
    private ResExchangeHeadDTO head;
    /**
     * 请求数据
     */
    private T data;

    public ResExchangeDTO(ResExchangeHeadDTO head, T data) {
        this.head = head;
        this.data = data;
    }

    public ResExchangeDTO(ExchangeErrorEnum exchangeError, String msg, T data) {
        ResExchangeHeadDTO head = new ResExchangeHeadDTO();
        head.setStatusCode(exchangeError.getCode());
        head.setCode(exchangeError.getCode());
        if (StringUtils.isNotBlank(exchangeError.getCode())) {
            if (StringUtils.isNotBlank(msg)) {
                if (StringUtils.isBlank(exchangeError.getMsg())) {
                    head.setMsg(msg);
                } else {
                    head.setMsg(exchangeError.getMsg() + ":" + msg);
                }
            } else {
                head.setMsg(exchangeError.getMsg());
            }
        }
        this.head = head;
        if (data != null) {
            this.data = data;
        }

    }

    public ResExchangeDTO(ExchangeErrorEnum exchangeError, String msg) {
        ResExchangeHeadDTO head = new ResExchangeHeadDTO();
        head.setStatusCode(exchangeError.getCode());
        head.setCode(exchangeError.getCode());
        head.setStatus(exchangeError.getCode());
        if (StringUtils.isNotBlank(exchangeError.getCode())) {
            if (StringUtils.isNotBlank(msg)) {
                if (StringUtils.isBlank(exchangeError.getMsg())) {
                    head.setMsg(msg);
                    head.setMessage(msg);
                } else {
                    head.setMsg(exchangeError.getMsg() + ":" + msg);
                    head.setMessage(exchangeError.getMsg() + ":" + msg);
                }
            } else {
                head.setMsg(exchangeError.getMsg());
                head.setMessage(exchangeError.getMsg());
            }
        }
        this.head = head;
    }



    public ResExchangeDTO(ErrorEnum errorEnum, String msg) {
        ResExchangeHeadDTO head = new ResExchangeHeadDTO();
        head.setStatusCode(errorEnum.getCode());
        head.setCode(errorEnum.getCode());
        head.setStatus(errorEnum.getCode());
        if (StringUtils.isNotBlank(errorEnum.getCode())) {
            if (StringUtils.isNotBlank(msg)) {
                if (StringUtils.isBlank(errorEnum.getMsg())) {
                    head.setMsg(msg);
                    head.setMessage(msg);
                } else {
                    head.setMsg(errorEnum.getMsg() + ":" + msg);
                    head.setMessage(errorEnum.getMsg() + ":" + msg);
                }
            } else {
                head.setMsg(errorEnum.getMsg());
                head.setMessage(errorEnum.getMsg());
            }
        }
        this.head = head;
    }




    public ResExchangeDTO() {

    }
}
