package cn.gtmap.hlw.core.util.string;

import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;

/**
 * @Author jianglin
 * @Date 2025/9/28
 * @Description
 */
@Slf4j
public class PublicUtil {
    /**
     * json数组转对象列表
     * 不抛出异常
     * @param obj
     * @param tClass
     * @return
     */
    public static <T> List<T> getBeanListByJsonArray(Object obj, Class<T> tClass) {
        List<T> t = null;
        try {
            if (obj instanceof String) {
                t = JSON.parseArray(obj.toString(), tClass);
            } else {
                t = JSON.parseArray(JSON.toJSONString(obj), tClass);
            }
        } catch (Exception e) {
            //logger.error(e.getMessage());
            log.error("getBeanListByJsonArray:" + e.getMessage());
        }
        return t;
    }

    /**
     * json对象转对象
     * 不抛出异常
     * @param json
     * @param tClass
     * @return
     */

    public static <T> T getBeanByJsonObj(Object json, Class<T> tClass) {
        T t = null;
        try {
            //t = JSON.parseObject(JSON.toJSONString(json), tClass);
            if (json instanceof String) {
                //防止String类型被JSON.toJSONString(json)时，外面包裹一层""；无法转成JSON对象
                t = JSON.parseObject(json.toString(), tClass);
            } else {
                t = JSON.parseObject(JSON.toJSONString(json), tClass);
            }
        } catch (Exception e) {
            log.error("getBeanByJsonObj:"+e.getMessage());
        }
        return t;
    }

    /**
     * @param
     * @return
     * @author <a href="mailto:liwenwu@gtmap.cn">liwenwu</a>
     * @version 2.0,
     * @description 根据手机号生成随机用户名
     */
    public static String getUserNameByLxdh(String lxdh) {
        String userName = null;
        //生成规则：yhm+手机号末四位+6位随机数字
        if (StringUtils.isNotBlank(lxdh)) {
            userName = "yhm" + lxdh.substring(lxdh.length() - 4, lxdh.length()) + RandomStringUtils.randomNumeric(6);
            ;
        }
        return userName;
    }

    /**
     * @param
     * @return
     * @author <a href="mailto:liwenwu@gtmap.cn">liwenwu</a>
     * @version 2.0,
     * @description 将字符串和数组里的字符串进行对比，存在即返回true
     */
    public static boolean compareString(String target, List<String> source) {
        if (StringUtils.isNotBlank(target) && source.size() > 0) {
            for (String compare : source) {
                if (StringUtils.equals(compare, target)) {
                    return true;
                }
            }
            return false;
        } else {
            return false;
        }
    }


    /**
     * 检查给定实体对象中是否有任何非 static、非基本数据类型的字段的值不为 null。
     *
     * @param entity 要检查的实体对象
     * @return 如果至少有一个字段不为 null，则返回 true；否则返回 false。
     * @throws IllegalArgumentException 如果传入的对象为 null
     */
    public static boolean hasAnyFieldNotNull(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("实体对象不能为 null");
        }

        // 获取实体类的 Class 对象
        Class<?> clazz = entity.getClass();

        // 遍历所有声明的字段，包括私有字段
        for (Field field : clazz.getDeclaredFields()) {
            int modifiers = field.getModifiers();

            // 1. 排除 static 字段 (如 serialVersionUID)
            if (Modifier.isStatic(modifiers)) {
                continue;
            }

            // 2. 排除基本数据类型字段 (primitive types)，因为它们永远不会是 null
            // 只有包装类和引用类型才需要检查是否为 null
            if (field.getType().isPrimitive()) {
                continue;
            }

            // 确保可以访问私有字段
            field.setAccessible(true);
            try {
                // 获取字段的值
                Object value = field.get(entity);

                // 检查值是否不为 null
                if (value != null) {
                    // 只要找到一个不为 null 的字段，立即返回 true
                    return true;
                }
            } catch (IllegalAccessException e) {
                // 无法访问字段，跳过
                System.err.println("无法访问字段 " + field.getName() + ": " + e.getMessage());
            }
        }
        // 遍历完所有字段都没有找到不为 null 的，返回 false
        return false;
    }
}
