package cn.gtmap.hlw.core.util.jwt;

import cn.gtmap.hlw.core.base.UserInfo;
import cn.gtmap.hlw.core.enums.error.TokenErrorEnum;
import cn.gtmap.hlw.core.exception.TokenException;
import cn.gtmap.hlw.core.util.bean.BeanConvertUtil;
import cn.gtmap.hlw.core.util.thread.ThreadLocalUtils;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.common.collect.Maps;

import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

/**
 * jwt - access_token令牌管理类
 *
 * @author admin
 * @version v1.0
 * @Date 2023/4/17 17:11
 */
public class Jwt {
    /**
     * 过期时间
     */
    private static int expireDate;

    public static int getExpireDate() {
        return expireDate;
    }

    public static void setExpireDate(int expireDate) {
        Jwt.expireDate = expireDate;
    }

    /**
     * 秘钥
     */
    private static String SECRET = "lww9227wxb1992hyk920709sl017zp17";


    /**
     * 生成token
     *
     * @param map //传入payload
     * @return 返回token
     */
    public static String creatToken(Map<String, String> map) {
        JWTCreator.Builder builder = JWT.create();
        map.forEach((k, v) -> builder.withClaim(k, v));
        Calendar instance = Calendar.getInstance();
        instance.add(Calendar.MINUTE, expireDate);
        builder.withExpiresAt(instance.getTime());
        return builder.sign(Algorithm.HMAC256(SECRET));
    }

    /**
     * 验证token
     *
     * @param token
     */
    public static void verify(String token) {
        JWT.require(Algorithm.HMAC256(SECRET)).build().verify(token);
    }

    /**
     * 获取token中payload
     *
     * @param token
     * @return
     */
    public static DecodedJWT getToken(String token) {
        return JWT.require(Algorithm.HMAC256(SECRET)).build().verify(token);
    }

    /**
     * 获取token Payload
     *
     * @param token
     * @return Map
     */
    public static Map<String, String> getPayload(String token) {

        Map<String, String> map = Maps.newHashMap();
        DecodedJWT decode = JWT.decode(token);

        Map<String, Claim> claimMap = decode.getClaims();
        if (Objects.isNull(claimMap)) {
            throw new TokenException(TokenErrorEnum.EMPTY_TOKEN_ERROR);
        }
        Iterator<Map.Entry<String, Claim>> iterator = claimMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Claim> entry = iterator.next();
            map.put(entry.getKey(), decode.getClaim(entry.getKey()).asString());
        }

        Object userInfo = BeanConvertUtil.convertMap(map, UserInfo.class);
        ThreadLocalUtils.set("userInfo", userInfo);

        return map;

    }
}
