package cn.gtmap.hlw.core.repository;


import cn.gtmap.hlw.core.model.WctJyHsxx;

import java.util.List;
import java.util.Map;

/**
 * (WctJyHsxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 11:39:31
 */
public interface WctJyHsxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    WctJyHsxx get(String id);

    /**
     * 新增数据
     *
     * @param wctJyHsxx 实例对象
     * @return 影响行数
     */
    void save(WctJyHsxx wctJyHsxx);

    /**
     * 修改数据
     *
     * @param wctJyHsxx 实例对象
     * @return 影响行数
     */
    void update(WctJyHsxx wctJyHsxx);
    /**
     * 通过sfssxxid查询数据
     *
     * @param sfssxxid 主键
     * @return 实例对象
     */
    List<WctJyHsxx> listBySfssxxid(String sfssxxid);
    /**
     * 根据sfssxxid删除数据
     *
     * @param sfssxxid 主键
     * @return
     */
    void deleteBySfssxxid(String sfssxxid);
    /**
     * 根据ids删除数据
     *
     * @param ids 主键
     * @return
     */
    void deleteByIds(List<String> ids);

    /**
     * 通过nsrsbh、slbh修改数据
     *
     * @param wctJyHsxx 实例对象
     * @param nsrsbh
     * @param slbh
     * @return 影响行数
     */
    void updateByNsrsbhAndSlbh(WctJyHsxx wctJyHsxx, String nsrsbh, String slbh);

    /**
     * 通过slbh查询数据
     *
     * @param slbh 主键
     * @return 实例对象
     */
    List<WctJyHsxx> listBySlbh(String slbh);

    /**
     * 批量更新
     * @param wctJyHsxxList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void saveOrUpdateBatch(List<WctJyHsxx> wctJyHsxxList);

    /**
     * 通过列名查询
     * @param map
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<WctJyHsxx> getListByMap(Map<String, Object> map);
    /**
     * 根据slbh和qlrlb查询
     * @param slbh
     * @param qlrlb
     * @return:java.util.List<cn.gtmap.hlw.core.model.WctJyHsxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<WctJyHsxx> listBySlbhAndQlrlb(String slbh, String qlrlb);
}

