package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.dict.zd.ZdQueryDTO;
import cn.gtmap.hlw.core.dto.dict.zd.ZdTypeListQueryDTO;
import cn.gtmap.hlw.core.model.GxYyZdType;

import java.util.List;
import java.util.Map;

/**
 * 不动产字典类型表(GxYyZdType)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 16:38:57
 */
public interface GxYyZdTypeRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyZdType get(String id);

    /**
     * 新增数据
     *
     * @param gxYyZdType 实例对象
     * @return 影响行数
     */
    void save(GxYyZdType gxYyZdType);

    /**
     * 修改数据
     *
     * @param gxYyZdType 实例对象
     * @return 影响行数
     */
    void update(GxYyZdType gxYyZdType);

    /**
     * 根据类型查询通用字典
     *
     * @param type 实例对象
     * @return 影响行数
     */
    List<GxYyZdType> getRedisListByTypeAndFdm(String type, String fdm);

    List<GxYyZdType> list(String type);

    List<GxYyZdType> getRedisList(String type);
    /**
     * 根据类型查询通用字典
     *
     * @param typeList 实例对象
     * @return 影响行数
     */

    List<GxYyZdType> getRedisListByZdType(List<String> typeList);

    List<GxYyZdType> listByTypeAndFdm(String type, String fdm);

    List<GxYyZdType> listByZdType(List<String> typeList);

    /**
     * 根据tablename 从redis中查询数据
     *
     * @param tableName
     * @return:Map<String,Object>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    Map<String, Object> getRedisGxYyZdTypeByTableName(String tableName);

    /**
     * 根据代码查询名称
     *
     * @param tableName
     * @param dm
     * @return:String
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    String getRedisUtilsDictMcByDm(String tableName, String dm);

    /**
     * 查询所有配置项
     *
     * @return
     */
    List<GxYyZdType> getAll();

    /**
     * 根据dm查询所有配置项
     *
     * @param dmList
     * @param typeList
     * @return
     */
    List<GxYyZdType> getRedisMcBydmList(List<String> dmList, List<String> typeList);

    /**
     * 分页查询
     *
     * @param queryDTO
     * @return
     */
    PageInfo<GxYyZdType> queryPage(ZdQueryDTO queryDTO);

    /**
     * 新增或修改
     *
     * @param gxYyZdType
     */
    void saveOrUpdate(GxYyZdType gxYyZdType);

    /**
     * 删除
     *
     * @param id
     */
    void delete(String id);

    /**
     * 批量保存
     *
     * @param zdTypeList
     */
    void saveOrUpdateBatch(List<GxYyZdType> zdTypeList);
    /**
     * 根据名称查询代码
     * @param tableName
     * @param mc
     * @return:String
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    String getRedisUtilsDictDmByMc(String tableName, String mc);

    /**
     * 根据类型查询通用字典
     *
     * @param paramsDTO 实例对象
     * @return 影响行数
     */
    List<GxYyZdType> getByTypeAndFdm(ZdTypeListQueryDTO paramsDTO);

    /**
     * 根据类型和代码查询
     * @param zdType
     * @param dmList
     * @return:List<GxYyZdType>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyZdType> getByTypeAndDmList(String zdType, List<String> dmList);

    /**
     * 根据dm查询所有配置项
     * @param dm
     * @param type
     * @return
     */
    String getDictMcByDm(String dm, String type);

    /**
     * 根据type删除字典项
     * @param zdType
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteByType(String zdType);

    /**
     * 批量插入
     * @param copyList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void insertBatch(List<GxYyZdType> copyList);
}

