package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.dict.tk.ZdSqxxTkDetailParamsDTO;
import cn.gtmap.hlw.core.dto.dict.tk.ZdSqxxTkQueryDTO;
import cn.gtmap.hlw.core.model.GxYyZdSqxxTk;

import java.util.List;

/**
 * 在线申请--闻讯笔录--题库(GxYyZdSqxxTk)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 16:38:58
 */
public interface GxYyZdSqxxTkRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param dm 主键
     * @return 实例对象
     */
    GxYyZdSqxxTk get(String dm);
    /**
     * 查询相同一类题库
     *
     * @param paramsDTO
     * @return 实例对象
     */
    List<GxYyZdSqxxTk> getBySqlxAndQlrlx(ZdSqxxTkDetailParamsDTO paramsDTO);

    /**
     * 新增数据
     *
     * @param gxYyZdSqxxTk 实例对象
     * @return 影响行数
     */
    void save(GxYyZdSqxxTk gxYyZdSqxxTk);

    /**
     * 修改数据
     *
     * @param gxYyZdSqxxTk 实例对象
     * @return 影响行数
     */
    void update(GxYyZdSqxxTk gxYyZdSqxxTk);

    /**
     * 获取数据
     *
     * @param qlrlx 权利人类型
     * @param sqlx  申请类型
     * @param dm
     * @return 影响行数
     */
    GxYyZdSqxxTk getSqxxTkListByQueryParams(String qlrlx, String sqlx, String dm);

    /**
     * 获取数据
     *
     * @param qlrlx 权利人类型
     * @param sqlx  申请类型
     * @return 影响行数
     */
    List<GxYyZdSqxxTk> getInitSqxxTkListByQueryParams(String qlrlx, String sqlx);
    /**
     * 获取数据
     *@param sqlx  申请类型
     * @return 影响行数
     */
    List<GxYyZdSqxxTk> getQlrLx(String sqlx);
    /**
     * 获取数据
     *@param sqlx  申请类型
     * @return 影响行数
     */
    List<GxYyZdSqxxTk> getBySqlx(String sqlx);
    /**
     * 获取数据
     * @return 影响行数
     */
    List<GxYyZdSqxxTk> getAll();

    /**
     *分页查询
     * @param paramsDTO
     * @return
     */
    PageInfo<GxYyZdSqxxTk> queryPage(ZdSqxxTkQueryDTO paramsDTO);

    /**
     * 删除
     * @param id 主键
     * @return 删除的数量
     */
    int delete(String id);
    /**
     *删除
     * @param sqlx
     * @return 删除的条数
     */
    int deleteBySqlx(String sqlx);

    /**
     * 保存更新
     * @param gxYyZdSqxxTk
     */
    void saveOrUpdate(GxYyZdSqxxTk gxYyZdSqxxTk);
    /**
     * 批量保存更新
     * @param gxYyZdSqxxTkList
     */
    void saveOrUpdateBatch(List<GxYyZdSqxxTk> gxYyZdSqxxTkList);

    /**
     * 根据申请类型查询题库
     *
     * @param sqlx 申请类型
     * @return 题库列表
     */
    List<GxYyZdSqxxTk> listBySqlx(String sqlx);

    /**
     * 批量插入题库
     *
     * @param zdSqxxTkList 题库集合
     */
    void insertBatchSomeColumn(List<GxYyZdSqxxTk> zdSqxxTkList);
}

