package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyUserMenuRel;

import java.util.List;

/**
 * 菜单收藏功能(GxYyUserMenuRel)表数据库访问层
 *
 * @author makejava
 * @since 2023-07-25 14:46:08
 */
public interface GxYyUserMenuRelRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyUserMenuRel get(String id);

    /**
     * 新增数据
     *
     * @param gxYyUserMenuRel 实例对象
     * @return 影响行数
     */
    void save(GxYyUserMenuRel gxYyUserMenuRel);

    /**
     * 修改数据
     *
     * @param gxYyUserMenuRel 实例对象
     * @return 影响行数
     */
    void update(GxYyUserMenuRel gxYyUserMenuRel);

    /**
     * 删除数据
     *
     * @param id 对象id
     * @return 影响行数
     */
    int delete(String id);

    /**
     * 获取数据
     *
     * @param roleId         角色id
     * @param userId         用户id
     * @param functionMenuId 菜单id
     * @return 影响行数
     */
    GxYyUserMenuRel getByParams(String roleId, String userId, String functionMenuId);
    /**
     * 获取数据
     *
     * @param roleId 角色id
     * @param userId 用户id
     * @return 影响行数
     */
    List<GxYyUserMenuRel> getByRoleIdAndUserId(String roleId, String userId);

}

