package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.equip.EquipDetailQueryDTO;
import cn.gtmap.hlw.core.dto.equip.EquipDetailResultDTO;
import cn.gtmap.hlw.core.model.GxYyUserEquipRel;

import java.util.List;

/**
 * 人员设备关系表(GxYyUserEquipRel)表数据库访问层
 *
 * @author makejava
 * @since 2023-10-26 09:06:14
 */
public interface GxYyUserEquipRelRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param relid 主键
     * @return 实例对象
     */
    GxYyUserEquipRel get(String relid);

    /**
     * 新增数据
     *
     * @param gxYyUserEquipRel 实例对象
     * @return 影响行数
     */
    void save(GxYyUserEquipRel gxYyUserEquipRel);

    /**
     * 修改数据
     *
     * @param gxYyUserEquipRel 实例对象
     * @return 影响行数
     */
    void update(GxYyUserEquipRel gxYyUserEquipRel);

    /**
     * 获取用户设备信息
     *
     * @param userGuid
     * @return
     */
    GxYyUserEquipRel getByUserGuid(String userGuid);

    /**
     * 分页查询
     *
     * @param paramsDTO
     * @return:PageInfo<EquipDetailResultDTO>
     * @author wangzhiwen
     */
    PageInfo<EquipDetailResultDTO> page(EquipDetailQueryDTO paramsDTO);

    /**
     * 保存
     *
     * @param gxYyUserEquipRel
     * @return:PageInfo<EquipDetailResultDTO>
     * @author wangzhiwen
     */
     void saveOrUpdate(GxYyUserEquipRel gxYyUserEquipRel);

    /**
     * 保存
     *
     * @param gxYyUserEquipRelList
     * @return:PageInfo<EquipDetailResultDTO>
     * @author wangzhiwen
     */
    void saveOrUpdateBatch(List<GxYyUserEquipRel> gxYyUserEquipRelList);


    /**
     * 查询
     *
     * @param equipId 设备id
     * @return:PageInfo<EquipDetailResultDTO>
     * @author wangzhiwen
     */
    List<GxYyUserEquipRel> queryByEquipId(String equipId);

    /**
     * 查询
     *
     * @param equipIdList 设备id集合
     * @return:PageInfo<EquipDetailResultDTO>
     * @author wangzhiwen
     */
    List<GxYyUserEquipRel> queryByEquipIdList(List<String> equipIdList);

    /**
     * 通过用户id集合，设备id 删除设备与用户关系
     *
     * @param equipId      设备id
     * @param userGuidList 用户集合
     * @author wangzhiwen
     */
    void deleteByEquipIdAndUserGuidList(String equipId, List<String> userGuidList);

    /**
     * @param
     * @return
     * @author chenjia
     * @description 根据用户id查询用户设备关系
     */
    GxYyUserEquipRel queryByUserGuid(String userGuid);

    /**
     * @param
     * @return
     * @author wangzhiwen
     * @description 根据用户id删除用户设备关系
     */
    void deleteByUserId(String userGuid);
}

