package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqxxKz;

import java.util.List;

/**
 * (GxYySqxxKz)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:46
 */
public interface GxYySqxxKzRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param sqid 主键
     * @return 实例对象
     */
    GxYySqxxKz get(String sqid);

    /**
     * 新增数据
     *
     * @param gxYySqxxKz 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxKz gxYySqxxKz);

    /**
     * 批量保存或修改数据
     *
     * @param gxYySqxxKzList 实例对象
     * @return
     */
    void saveOrUpdateBatch(List<GxYySqxxKz> gxYySqxxKzList);

    /**
     * 修改数据
     *
     * @param gxYySqxxKz 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxKz gxYySqxxKz);

    /**
     * 通过sqidList修改proid
     *
     * @param
     * @return 影响行数
     */
    void updateProid(List<String> sqidList, String proid);

    /**
     * 通过sqidList查询集合数据
     *
     * @param sqidList
     * @return 实例对象
     */
    List<GxYySqxxKz> list(List<String> sqidList);

    /**
     * 通过sqidList删除数据
     *
     * @param sqidList
     * @return 影响行数
     */
    int deleteBySqidList(List<String> sqidList);

    /**
     * 新增或修改数据
     *
     * @param gxYySqxxKz 实例对象
     * @return 影响行数
     */
    void saveOrUpdate(GxYySqxxKz gxYySqxxKz);

    /**
     * 批量插入
     *
     * @param sqxxKzList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void insertBatch(List<GxYySqxxKz> sqxxKzList);


    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 根据扩展json参数查询扩展信息
     */
    List<GxYySqxxKz> getSqxxKzJSON(String kzJsonCs);
}

