package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.equip.EquipDetailQueryDTO;
import cn.gtmap.hlw.core.dto.equip.EquipDetailResultDTO;
import cn.gtmap.hlw.core.model.GxYySbgl;

/**
 * @author wangzhiwen
 * @version 2024/3/18 11:19
 * @description 设备管理
 */
public interface GxYySbglRepository {

    /**
     * 分页查询
     *
     * @param paramsDTO
     * @return:PageInfo<EquipDetailResultDTO>
     * @author wangzhiwen
     */
    PageInfo<EquipDetailResultDTO> page(EquipDetailQueryDTO paramsDTO);

    /**
     * 通过设备id删除设备
     *
     * @param sbid 设备id
     * @return:PageInfo<EquipDetailResultDTO>
     * @author wangzhiwen
     */
    void deleteBySbid(String sbid);

    /**
     * 通过设备id查询设备
     *
     * @param sbid 设备id
     * @return:PageInfo<EquipDetailResultDTO>
     * @author wangzhiwen
     */
    GxYySbgl queryBySbid(String sbid);

    /**
     * 保存或更新
     *
     * @param gxYySbgl
     * @author wangzhiwen
     */
    void saveOrUpdate(GxYySbgl gxYySbgl);
}
