package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyMenuUserRel;

import java.util.List;

/**
 * 菜单用户关系(GxYyMenuUserRel)表数据库访问层
 *
 * @author makejava
 * @since 2023-07-25 14:46:08
 */
public interface GxYyMenuUserRelRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyMenuUserRel get(String id);

    /**
     * 新增数据
     *
     * @param gxYyMenuUserRel 实例对象
     * @return 影响行数
     */
    void save(GxYyMenuUserRel gxYyMenuUserRel);

    /**
     * 修改数据
     *
     * @param gxYyMenuUserRel 实例对象
     * @return 影响行数
     */
    void update(GxYyMenuUserRel gxYyMenuUserRel);

    /**
     * 删除数据
     *
     * @param id 对象id
     * @return 影响行数
     */
    int delete(String id);
    /**
     * 根据菜单id和用户id查询
     * @param functionMenuId
     * @param userId
     * @return:cn.gtmap.hlw.core.model.GxYyMenuUserRel
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYyMenuUserRel getByMenuIdAndUserId(String functionMenuId, String userId);
    /**
     * 根据用户删除
     * @param userId
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void delByUserId(String userId);
    /**
     * 批量保存
     * @param gxYyMenuUserRelList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void saveBatch(List<GxYyMenuUserRel> gxYyMenuUserRelList);
    /**
     * 根据菜单id查询
     * @param functionMenuId
     * @return:java.util.List<cn.gtmap.hlw.core.model.GxYyMenuUserRel>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyMenuUserRel> listByMenuId(String functionMenuId);
    /**
     * 根据菜单删除
     * @param functionMenuId
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void delByMenuId(String functionMenuId);
    /**
     * 根据用户查询
     * @param userId
     * @return:java.util.List<cn.gtmap.hlw.core.model.GxYyMenuUserRel>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyMenuUserRel> listByUserId(String userId);
}

