package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.djzx.DjzxZdRelQueryDTO;
import cn.gtmap.hlw.core.model.GxYyDjzxZdRel;

import java.util.List;

/**
 * 登记中心与字典关系表(GxYyDjzxZdRel)表数据库访问层
 *
 * @author makejava
 * @since 2024-02-06 17:03:41
 */
public interface GxYyDjzxZdRelRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyDjzxZdRel get(String id);

    /**
     * 批量保存或更新数据
     *
     * @param djzxZdRelList 实例对象列表
     */
    void saveOrUpdateBatch(List<GxYyDjzxZdRel> djzxZdRelList);

    /**
     * 批量删除
     *
     * @param idList ID列表
     */
    void deleteBatch(List<String> idList);

    /**
     * 根据登记中心代码删除
     *
     * @param djzxdm 登记中心代码
     */
    void deleteByDjzxdm(String djzxdm);

    /**
     * 分页查询
     *
     * @param queryDTO 查询参数
     * @return 分页结果
     */
    PageInfo<GxYyDjzxZdRel> page(DjzxZdRelQueryDTO queryDTO);

    /**
     * 查询
     * @param queryDTO
     * @return
     */
    List<GxYyDjzxZdRel> queryByDjzxdm(DjzxZdRelQueryDTO queryDTO);

}
