package cn.gtmap.hlw.core.model.history;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 历史--申请信息中介信息(HgxYySqxxZjxx)表实体类BO
 *
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @since 2023-08-09 17:37:51
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class HgxYySqxxZjxx implements Serializable {

    private static final long serialVersionUID = 5011361072199208943L;
    /**
     * 申请ID(gx_yy_sqxx.SQID)
     */
    private String sqid;

    /**
     * 受理编号(gx_yy_sqxx.SLBH)
     */
    private String slbh;

    /**
     * 中介名称
     */
    private String zjmc;

    /**
     * 中介证件种类
     */
    private String zjzjzl;

    /**
     * 中介证件编号
     */
    private String zjzjbh;

    /**
     * 中介代理人名称
     */
    private String zjdlrmc;

    /**
     * 中介代理人证件种类
     */
    private String zjdlrzjzl;

    /**
     * 中介代理人证件编号
     */
    private String zjdlrzjbh;

    /**
     * 中介代理人联系电话
     */
    private String zjdlrlxdh;

    /**
     * 主键 (使用UUID通用工具类的hex32()方法生成)
     */
    private String id;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 创建人员(gx_yy_user.USER_GUID)
     */
    private String createUser;

    /**
     * 脱敏字段中介名称
     */
    private String zjmcTm;

    /**
     * 脱敏字段中介证件编号
     */
    private String zjzjbhTm;

    /**
     * 脱敏字段中介代理人名称
     */
    private String zjdlrmcTm;

    /**
     * 脱敏字段中介代理人证件编号
     */
    private String zjdlrzjbhTm;

    /**
     * 脱敏字段中介代理人联系电话
     */
    private String zjdlrlxdhTm;

    /**
     * 地址
     */
    private String dz;

    /**
     * 备案证号
     */
    private String bazh;

    /**
     * 联系电话
     */
    private String lxdh;

    /**
     * 从业资质证号
     */
    private String cyzzzh;

    /**
     * 法人代表
     */
    private String frdb;

    /**
     * 法人代表证件种类
     */
    private String frdbzjzl;

    /**
     * 法人代表证件号
     */
    private String frdbzjh;
}

