package cn.gtmap.hlw.core.model.history;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 历史--申请信息资金监管(HgxYySqxxZjjg)表实体类BO
 *
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @since 2023-08-09 17:34:51
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class HgxYySqxxZjjg implements Serializable {
    private static final long serialVersionUID = 5888183835667551237L;
    /**
     * 申请id
     */
    private String sqid;

    /**
     * 受理编号
     */
    private String slbh;

    /**
     * 监管银行代码（JGXH字典表）
     */
    private String jgyhdm;

    /**
     * 义务人（卖方）姓名
     */
    private String ywrxm;

    /**
     * 义务人（卖方）银行账户
     */
    private String ywryhzh;

    /**
     * 权利人（买方）姓名
     */
    private String qlrxm;

    /**
     * 权利人（买方）银行账户
     */
    private String qlryhzh;

    /**
     * 监管金额（元)
     */
    private String jgje;

    /**
     * 是否监管定金（0:不监管 1:监管）
     */
    private String sfjgdj;

    /**
     * 利息归属（0:卖方 1:买方）
     */
    private String lxgs;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 创建人员(gx_yy_user.USER_GUID)
     */
    private String createUser;

    /**
     * 修改人员(gx_yy_user.USER_GUID)
     */
    private String updateUser;

    /**
     * 资金监管收款账户户名
     */
    private String skzhmc;

    /**
     * 资金监管收款账户收款账号
     */
    private String skzhzh;


}

