package cn.gtmap.hlw.core.model.history;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 历史--申请信息收费信息(HgxYySqxxSfxx)表实体类BO
 *
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @since 2023-08-09 17:24:46
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class HgxYySqxxSfxx implements Serializable {
    private static final long serialVersionUID = -4590474335554016256L;
    /**
     * 主键ID
     */
    private String id;

    /**
     * 受理编号(gx_yy_sqxx.SLBH)
     */
    private String slbh;

    /**
     * 票据号（非税缴款书编号）
     */
    private String pjh;

    /**
     * 权利人类型（QLRLX字典）
     */
    private String qlrlx;

    /**
     * 缴费人证件号
     */
    private String jfrzjh;

    /**
     * 缴费人名称
     */
    private String jfrmc;

    /**
     * 收费项目代码（SFXM字典）
     */
    private String sfxmdm;

    /**
     * 收费标准（元）
     */
    private String sfbz;

    /**
     * 数量
     */
    private String sl;

    /**
     * 数量单位代码（SLDW字典）
     */
    private String sldwdm;

    /**
     * 应缴金额（元）
     */
    private String yjje;

    /**
     * 应缴金额合计（元）
     */
    private String yjjehj;

    /**
     * 权利人类型应缴金额合计
     */
    private String qlrlxyjjehj;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 创建人员(gx_yy_user.USER_GUID)
     */
    private String createUser;

    /**
     * 修改人员(gx_yy_user.USER_GUID)
     */
    private String updateUser;


}

