package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.sql.Date;


/**
 * 互联网申请信息预告信息表(hlw_sqxx_ql_ygxx)表数据库访问层
 *
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @since 2025-06-24 09:26:36
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class HlwSqxxQlYgxx implements Serializable {
    private static final long serialVersionUID = 7622981289130104888L;
    private Integer fyzxrid;

    /**
     * 主键
     */
    private String ygid;
    /**
     * 申请id
     */
    private String sqid;
    /**
     * 不动产单元号
     */
    private String bdcdyh;
    /**
     * 不动产坐落
     */
    private String zl;
    /**
     * 预告登记种类代码
     */
    private String ygdjzldm;
    /**
     * 土地使用权人
     */
    private String tdsyqr;
    /**
     * 规划用途代码
     */
    private String ghytdm;
    /**
     * 房屋性质代码
     */
    private String fwxzdm;
    /**
     * 房屋结构代码
     */
    private String fwjgdm;
    /**
     * 所在层
     */
    private String szc;
    /**
     * 总层数
     */
    private Integer zcs;
    /**
     * 建筑面积（单位：平方米）
     */
    private Float jzmj;
    /**
     * 不动产登记证明号
     */
    private String bdcdjzmh;
    /**
     * 附记
     */
    private String fj;
    /**
     * 取得价格/被担保主债权数额
     */
    private Double qdjg;
    /**
     * 担保范围
     */
    private String dbfw;
    /**
     * 是否存在禁止或者限制转让抵押不动产的约定
     */
    private String sfczjzhxz;
    /**
     * 登记时间
     */
    private Date djsj;
    /**
     * 债务履行起始时间
     */
    private Date zwlxqssj;
    /**
     * 债务履行结束时间
     */
    private Date zwlxjssj;
    /**
     * 交易金额（单位：元）
     */
    private Float jyje;
    /**
     * 所在名义层
     */
    private String szmyc;
    /**
     * 分摊土地面积
     */
    private Float fttdmj;
    /**
     * 土地使用起始时间
     */
    private Date tdsyqssj;
    /**
     * 土地使用结束时间
     */
    private Date tdsyjssj;
    /**
     * 抵押方式代码
     */
    private String dyfsdm;
    /**
     * 不动产单元编号
     */
    private String bdcdybh;
    /**
     * 房间号
     */
    private String fjh;
    /**
     * 幢号
     */
    private String zh;
    /**
     * 抵押范围
     */
    private String dyfw;
    /**
     * 土地使用起始时间2，国有建设用地需填写
     */
    private Date tdsyqssj2;
    /**
     * 土地使用结束时间2，国有建设用地需填写
     */
    private Date tdsyjssj2;
    /**
     * 土地使用起始时间3，国有建设用地需填写
     */
    private Date tdsyqssj3;
    /**
     * 土地使用结束时间3，国有建设用地需填写
     */
    private Date tdsyjssj3;
    /**
     * 抵押顺位
     */
    private String dysw;


}

