package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;


/**
 * 工作流节点与领域事件关系表(GxYyProcessLysjRel)表实体类BO
 *
 * @author makejava
 * @since 2023-06-06 14:39:57
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyProcessLysjRel implements Serializable {
    private static final long serialVersionUID = -6239336125837724310L;
    private String plid;

    /**gx_yy_process表id*/
    private String processId;

    /**gx_yy_lysj表dm*/
    private String lysjdm;

    /**领域事件执行时间（before：之前执行，after：之后执行）*/
    private String lysjzxsj;

    /**事件级别（0：中断；1：忽略）*/
    private String lysjjb;

    /**领域事件是否顺序执行（0：否，1：是）(轻易不建议同步执行)*/
    private String lysjsftbzx;

    /**领域事件执行顺序（事件执行的顺序，如果是同步执行，顺序号填一样）*/
    private Integer lysjzxsx;

    /**领域动作代码*/
    private String lydzdmlist;

    /**
     * 按钮id（gx_yy_zd_an.anid）该字段如果为空表示页面初始化调用接口
     */
    private String anid;

    /**
     * 按钮名称（gx_yy_zd_an.anmc，可自定义）
     */
    private String anmc;

    /**
     * 按钮类型（gx_yy_zd_an.anlx，可自定义）
     */
    private String anlx;

    /**
     * 按钮顺序（1-99，1排在最前面，控制页面按钮排序）
     */
    private Integer ansx;

    /**
     * 按钮（前端）扩展配置（前端部分扩展配置）
     */
    private String ankzpz;
    /**
     * processs_an_rel 主键
     */
    private String paid;
}

