package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2025/6/24
 * @description 地籍调查单位信息
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyDjdcDwxx implements Serializable {
    private static final long serialVersionUID = 7758857385041294548L;
    /**
     * 主键
     */
    private String id;
    /**
     * 申请id
     */
    private String sqid;
    /**
     * 单位名称
     */
    private String dwmc;
    /**
     * 单位证件类型
     */
    private String dwzjlx;
    /**
     * 单位证件号
     */
    private String dwzjh;
    /**
     * 联系人
     */
    private String lxr;
    /**
     * 联系人证件号
     */
    private String lxrzjh;
    /**
     * 联系人联系方式
     */
    private String lxrlxfs;
    /**
     * 代理人
     */
    private String dlr;
    /**
     * 代理人联系方式
     */
    private String dlrlxfs;
    /**
     * 申请人类型（1：买受方2：受让方9：勘测单位）
     */
    private String sqrlx;
    /**
     * 代理人证件类型
     */
    private String dlrzjlx;
    /**
     * 代理人证件号
     */
    private String dlrzjh;
    /**
     * 法定代表人
     */
    private String fddbr;
    /**
     * 法定代表人证件类型
     */
    private String fddbrzjlx;
    /**
     * 法定代表人证件号
     */
    private String fddbrzjh;
    /**
     * 法定代表人联系方式
     */
    private String fddbrlxfs;
}
