package cn.gtmap.hlw.core.enums.web;


/**
 * @author admin
 * @version 1.0, 2023/05/15
 * @description 请求来源
 */
public enum OriginEnum {
    /**
     * 请求来源微信 - code
     */
    WECHAT("1", "微信"),
    /**
     * 请求来源web - code
     */
    WEB("2", "web"),
    /**
     * 请求来源APP - code
     */
    APP("3", "APP"),
    /**
     * 请求来源其他 - code
     */
    OTHER("4", "APP");

    private String code;

    private String name;

    OriginEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /**
     * 根据code获取枚举name
     */
    public static String getName(String code) {
        for (OriginEnum xq : OriginEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getName();
            }
        }
        return null;
    }
}

