package cn.gtmap.hlw.core.enums.qlr;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 权利人种类代码
 *
 * @author admin
 * @Date 2023-06-25
 * @Version V1.0
 */
@Getter
@AllArgsConstructor
public enum QlrCodeEnum {
    /**
     * 权利人种类代码 1 个人
     */
    QLRZL_GR("1", "个人"),
    /**
     * 权利人种类代码 2 企业
     */
    QLRZL_QY("2", "企业"),
    /**
     * 权利人种类代码 事业单位
     */
    QLRZL_SYDW("3", "事业单位"),
    /**
     * 权利人种类代码  国家机关
     */
    QLRZL_GJJG("4", "国家机关"),
    /**
     * 权利人种类代码  家庭
     */
    QLRZL_JT("5", "家庭"),
    /**
     * 土地储备机构
     */
    QLRZL_TDCBJG("6", "土地储备机构"),
    /**
     * 权利人种类代码 7 农村集体经济组织
     */
    QLRZL_NCJTJJZZ("7", "农村集体经济组织"),
    /**
     * 权利人种类代码 8 村民小组农民集体
     */
    QLRZL_CMXZNMJT("8", "村民小组农民集体"),
    /**
     * 权利人种类代码 9 村农民集体
     */
    QLRZL_CNMJT("9", "村农民集体"),
    /**
     * 权利人种类代码 10 乡(镇)农民集体
     */
    QLRZL_XZNMJT("10", "乡(镇)农民集体"),
    /**
     * 权利人种类代码 11 承包方
     */
    QLRZL_CBF("11", "承包方"),
    /**
     * 权利人种类代码 12 村民委员会
     */
    QLRZL_CMWYH("12", "村民委员会"),
    /**
     * 金融机构
     */
    QLRZL_JRJG("21", "金融机构"),
    /**
     * 非金融机构
     */
    QLRZL_FJRJG("22", "非金融机构"),
    /**
     * 权利人种类代码 其他
     */
    QLRZL_QT("99", "其他"),
    /**
     * 抵押情况--是
     */
    DYQK_YES("1", "是"),
    /**
     * 是否限购--是
     */
    SFXG_YES("1", "是"),
    /**
     * 是否限购--否
     */
    SFXG_NO("0", "否"),
    /**
     * 抵押情况--否
     */
    DYQK_NO("2", "否");


    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (QlrCodeEnum xq : QlrCodeEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }

    public static String getCode(String msg) {
        for (QlrCodeEnum xq : QlrCodeEnum.values()) {
            if (xq.msg.equals(msg)) {
                return xq.getCode();
            }
        }
        return null;
    }
}

