package cn.gtmap.hlw.core.enums.error;

import cn.gtmap.hlw.core.exception.IError;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author： admin
 * @Data: 2020/12/4
 * @Description: token异常
 */
@AllArgsConstructor
public enum TokenErrorEnum implements IError {
    /** 无效签名 code码 */
    SIGNATURE_VERIFICATION_ERROR("6001", "无效签名"),
    /** token过期 code码 */
    TOKEN_EXPIRED_ERROR("6002", "token过期"),
    /** token算法不一致 code码 */
    ALGORITHM_MISMATCH_ERROR("6003", "token算法不一致"),
    /** token信息为空 code码 */
    EMPTY_TOKEN_ERROR("6004", "token信息为空"),
    /** token失效 code码 */
    OTHER_TOKEN_ERROR("6005", "token失效");

    @Getter
    private String code;

    @Getter
    private String msg;

}
