package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2025/1/2
 * @description
 */
@Getter
@AllArgsConstructor
public enum TkztEnum {
    /**
     * 无法完成退款
     */
    TKZT_WTK("0", "未退款"),
    /**
     * 未退款
     */
    TKZT_TKZ("1", "退款中"),
    /**
     * 退款中
     */
    TKZT_TKCG("2", "退款成功"),
    /**
     * 退款失败
     */
    TKZT_TKSB("3", "退款失败"),
    /**
     * 退款成功
     */
    TKZT_WFWCTK("4", "无法完成退款"),
    /**
     * 无法完成退款
     */
    TKZT_BYTF("5", "不予退费");

    @Getter
    private String code;

    @Getter
    private String mc;

    public static String getMc(String code) {
        for (TkztEnum xq : TkztEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMc();
            }
        }
        return null;
    }
}
