package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author： admin
 * @Data: 2020/12/4
 * @Description: 受理状态
 */
@Getter
@AllArgsConstructor
public enum SlztEnum {

    /**  会签中*/
    SLZT_HQZ("0","会签中"),
    /**（登记） 审核中 */
    SLZT_SHZ("1","审核中"),
    /** 登记审核已通过 */
    SLZT_DJSHYTG("2","登记审核已通过"),
    /**（登记）未通过 */
    SLZT_WTG("3","未通过"),
    /** 预审通过 */
    SLZT_YSTG("4","预审通过"),
    /** 预审未通过 */
    SLZT_YSWTG("5","预审未通过"),
    /** 用户撤回 */
    SLZT_YHCH("6","用户撤回"),
    /** 办结 */
    SLZT_BJ("7","办结"),
    /** 会签通过 */
    SLZT_HQTG("8","会签通过"),
    /** 已审核 */
    SLZT_YSH("9","已审核"),
    /** 会签不通过 */
    SLZT_HQBTG("10","会签不通过"),
    /** 用户删除/用户作废 */
    SLZT_YHSC("11","用户删除"),
    /** 推送中 */
    SLZT_TSZ("12","推送中"),
    /** 已退回 */
    SLZT_YTH("13","已退回"),

    /** 登簿 */
    SLZT_DB("14","登簿"),
    /** 待审核 */
    SLZT_DSH("15","待审核"),
    /** 草稿 */
    SLZT_CG("16","草稿"),
    /** 复审通过 */
    SLZT_FSTG("17","复审通过"),
    /**
     * 复审不通过
     */
    SLZT_FSBTG("18","复审不通过"),
    /**
     * 待认领
     */
    SLZT_DRL("19","待认领"),
    /** 推送失败 */
    SLZT_TSSB("20","推送登记失败"),
    /** 受理状态-登记二审中 */
    SLZT_DJESZ("21","登记二审中"),
    /** 受理状态-登记二审通过 */
    SLZT_DJESTG("22","登记二审通过"),
    /** 受理状态-登记二审失败 */
    SLZT_DJESSB("23","登记二审失败"),
    /**
     * 登簿失败
     */
    SLZT_DBSB("24","登簿失败"),


    /** 受理状态-交易退回 */
    SLZT_JYTH("30","交易退回"),
    /** 受理状态-税务退回 */
    SLZT_SWTH("31","税务退回"),
    /** 受理状态-银行退回 */
    SLZT_YHTH("32","银行退回"),
    /** 已缮证*/
    SLZT_YSZ("99","已缮证");

    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (SlztEnum xq : SlztEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }

}
