package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 1.0, 2023/10/8
 * @description 签约类型枚举
 */
@Getter
@AllArgsConstructor
public enum QylxEnum {

    /**
     * 线上签订
     */
    QYLX_XS("0", "线上网签"),
    /**
     * 已备案
     */
    QYLX_XX("1", "线下备案");


    /**
     * 代码
     */
    @Getter
    private String dm;

    /**
     *    名称
     */
    @Getter
    private String mc;

    public static String getMc(String dm) {
        for (QylxEnum xq : QylxEnum.values()) {
            if (xq.dm.equals(dm)) {
                return xq.getMc();
            }
        }
        return null;
    }
}
