package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/8/25
 * @description
 */
@Getter
@AllArgsConstructor
public enum JdztEnum {
    /**
     * 未执行
     */
    JDZT_WZX("0", "未执行"),
    /**
     * 成功
     */
    JDZT_CG("1", "成功"),
    /**
     * 失败
     */
    JDZT_SB("2", "失败"),
    /**
     * 执行中
     */
    JDZT_ZXZ("3", "执行中"),
    /**
     * 无需执行
     */
    JDZT_WXZX("4", "无需执行");

    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (JdztEnum xq : JdztEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
