package cn.gtmap.hlw.core.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author： admin
 * @Data: 2020/12/4
 * @Description: 资源类型
 */
@Getter
@AllArgsConstructor
public enum ProcessTypeEnum {
    /**
     * 申请
     */
    PROCESS_TYPE_SQ("0", "申请"),
    /**
     * 核验
     */
    PROCESS_TYPE_HY("1", "核验"),
    /**
     * 查看
     */
    PROCESS_TYPE_CK("2", "查看"),
    /**
     * 退回修改
     */
    PROCESS_TYPE_THXG("3", "退回修改"),
    /**
     * 预审
     */
    PROCESS_TYPE_YS("4", "预审"),
    /**
     * 复审
     */
    PROCESS_TYPE_FS("5", "复审");

    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (ProcessTypeEnum xq : ProcessTypeEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }

}
