package cn.gtmap.hlw.core.dto.sw.hs;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/7/18
 * @description 房产交易信息
 */
@Data
public class SwHsFcjycjxxDTO {
    /**
     * 房屋交易 UUID
     */
    private String fwuuid;
    /**
     * 房产交易方式代码
     */
    @ZdDzConfig(field = "fcjyfsdm", tableName = ZdDzConstant.ZD_DZ_JYFS, dmToDm = true, defaultValue = "01")
    private String fcjyfsdm;
    /**
     * 契税权属转移类别代码
     */
    @ZdDzConfig(field = "qsqszylbdm", tableName = ZdDzConstant.ZD_DZ_QSQSZYLB, dmToDm = true, defaultValue = "21")
    private String qsqszylbdm;
    /**
     * 契税权属转移对象代码
     */
    @ZdDzConfig(field = "qsqszydxdm", tableName = ZdDzConstant.ZD_DZ_QSQSZYDX, dmToDm = true)
    private String qsqszydxdm;
    /**
     * 契税权属转移用途代码
     */
    @ZdDzConfig(field = "qsqszyytdm", tableName = ZdDzConstant.ZD_DZ_FWYT, dmToDm = true)
    private String qsqszyytdm;
    /**
     * 合同签订日期
     */
    private String htqdrq;
    /**
     * 合同编号
     */
    private String htbh;
    /**
     * 土地增值税扣除成本
     */
    private String tdzsskccb;
    /**
     * 当期应收税款金额
     */
    private String dqyskje;
    /**
     * 房屋产权证书号
     */
    private String fwcqzsh;
    /**
     * 是否普通住房标志
     */
    private String sfptzfbs;
    /**
     * 个人所得税扣除合理费用
     */
    private String grsdskchlfy;
    /**
     * 开发不动产项目编号
     */
    private String kfbdcxmbh;
    /**
     * 不动产项目名称
     */
    private String bdcxmmc;
    /**
     * 合同金额
     */
    private Double htje;
    /**
     * 交易价格
     */
    private Double jyjg;
    /**
     * 单价
     */
    private Double dj;
    /**
     * 外部交易价格
     */
    private Double wbjyjg;
    /**
     * 成交价是否含税标志
     */
    private String cjjgsfhs;
    /**
     * 本次申报交易是否属于转让方自开票
     */
    private String bcsbjysfsyzrfzkp;
    /**
     * 本次交易代付增值税税率或征收率
     */
    private String bcjydfzzsslhzsl;
    /**
     * 差额征收增值税标志
     */
    private String cezszzsbz;
    /**
     * 申报属性代码
     */
    private String sbsxdm1;
    /**
     * 备注
     */
    private String bz;
    /**
     * 当前应收税款所属月份
     */
    private String dqysskssyf;
    /**
     * 房屋类型代码
     */
    @JSONField(name = "fwlx_dm")
    @ZdDzConfig(field = "fwlxdm", tableName = ZdDzConstant.ZD_DZ_FWLX, dmToDm = true, defaultValue = "90")
    private String fwlxdm;
    /**
     * 买方共有方式
     */
    @JSONField(name = "csfgyfs_dm")
    @ZdDzConfig(field = "csfgyfsdm", tableName = ZdDzConstant.ZD_DZ_GYFS, dmToDm = true)
    private String csfgyfsdm;
    /**
     * 卖方共有方式
     */
    @JSONField(name = "zrfgyfs_dm")
    @ZdDzConfig(field = "zrfgyfsdm", tableName = ZdDzConstant.ZD_DZ_GYFS, dmToDm = true)
    private String zrfgyfsdm;
    /**
     * 是否不征契税
     */
    private String sfbzqs;
    /**
     * 契税不征税项目
     */
    @JSONField(name = "qsbzsxm_dm")
    private String qsbzsxmdm;
    /**
     * 权属登记日期
     */
    private String qsdjrq;
    /**
     * 中软必填 1:配偶、父母、子女、祖父母、外祖父母、孙子女、外孙子女
     * 2:兄弟姐妹
     * 3:承担直接抚养或者赡养义务的抚养人或赡养人
     * 4:法定继承人、遗嘱继承人、受遗赠人
     * 9:其他
     */
    private String zrfcsfgxdm;

    /**
     * 权属转移面积
     */
    private Double qszymj;
}
