package cn.gtmap.hlw.core.dto.sqxx.tz;

import cn.gtmap.hlw.core.base.BasePage;
import cn.hutool.core.date.DatePattern;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/29 16:23
 * @description MySqxxParamsDTO
 */
@Data
public class BankApplyQueryDTO extends BasePage {
    /**
     * 登陆人 此字段对应 gx_yy_sqxx.create_userid
     */
    private String userGuid;
    /**
     * 当前登陆人所属部门  此字段不作为查询条件，放在orgIdList作为查询条件
     */
    private String orgId;
    /**
     * 受理状态
     */
    private String slzt;

    /**
     *查询条件
     */
    /**
     * 本部门及下属之部门OrgId; gx_yy_sqxx.create_org_id
     */
    private List<String> orgIdList;
    /**
     * 需要查询的SLZT gx_yy_sqxx.slzt
     */
    private List<String> slztList;
    /**
     * 受理编号 slbh
     */
    private String slbh;
    /**
     * 权利人名称 gx_yy_sqxx.qlrmc ；不区分是否组合登记，都查
     */
    private String qlrmc;
    /**
     * 权利人名称 gx_yy_sqxx.ywrmc ；不区分是否组合登记，都查
     */
    private String ywrmc;
    /**
     * 申请类型 sqlx
     */
    private String sqlx;
    /**
     * 申请类型 gx_yy_sqxx.sqlx
     */
    private String sqlxmh;
    /**
     * 坐落 gx_yy_sqxx.zl 支持模糊查询
     */
    private String zl;
    /**
     * 是否查询历史数据
     */
    private String unionHis;
    /**
     * 税务状态 gx_yy_sqxx.swzt
     */
    private List<String> swztList;
    /**
     * 缴费状态 gx_yy_sqxx.jfzt
     */
    private List<String> jfztList;
    /**
     * 开始时间：yyyy-mm-dd 00:00:00  gx_yy_sqxx.create_date
     */
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private String kssj;

    /**
     * 开始时间：yyyy-mm-dd 23:59:59  gx_yy_sqxx.create_date
     */
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private String jssj;
}
