package cn.gtmap.hlw.core.dto.sqxx.save;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/7 22:07
 * @description 税务信息
 */
@Data
public class SwxxDTO implements Serializable {
    private String guid;

    /**
     * 受理编号
     */
    private String slbh;

    /**
     * 申请ID
     */
    private String sqid;

    /**
     * 系统税票号码
     */
    private String xtsphm;

    /**
     * 电子税票号码
     */
    private String dzsphm;

    /**
     * 合同编号
     */
    private String htbh;

    /**
     * 凭证种类代码
     */
    private String pzzlDm;

    /**
     * 凭证种类名称
     */
    private String pzzlMc;

    /**
     * 票证子规代码
     */
    private String pzzgDm;

    /**
     * 票证子规名称
     */
    private String pzzgMc;

    /**
     * 票证号码
     */
    private String pzhm;

    /**
     * 税款所属期起
     */
    private String skssqq;

    /**
     * 税款所属期止
     */
    private String skssqz;

    /**
     * 征收项目代码
     */
    private String zsxmDm;

    /**
     * 征收项目名称
     */
    private String zsxmMc;

    /**
     * 征收品目代码
     */
    private String zspmDm;

    /**
     * 征收品目名称
     */
    private String zspmMc;

    /**
     * 征收子目代码
     */
    private String zszmDm;

    /**
     * 征收子目名称
     */
    private String zszmMc;

    /**
     * 计税依据
     */
    private String jsyj;

    /**
     * 税率
     */
    private String sl;

    /**
     * 实际缴纳金额
     */
    private String sjje;

    /**
     * 主管税务机关科分局代码
     */
    private String zgswskfjDm;

    /**主管税务机关科分局名称*/
    private String zgswskfjMc;

    /**征收税务机关代码*/
    private String zsswjgDm;

    /**征收税务机关名称*/
    private String zsswjgMc;

    /**税款所属机关代码*/
    private String skssswjgDm;

    /**税款所属机关名称*/
    private String skssswjgMc;

    /**扣缴日期*/
    private String kjrq;

    /**
     * 备注
     */
    private String bz;

    /**创建人（user表关联user_guid）*/
    private String cjrUser;

    /**创建单位（关联部门id，orgid）*/
    private String cjrOrgid;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date cjsj;

    /**纳税人*/
    private String nsrmc;

    /**纳税人识别号*/
    private String nsrsbh;

    /**转让方承受方标志（ 0转让方  1承受方）*/
    private String zrfcsfbz;

    /**登记注册类型*/
    private String djzclx;

    /**税票号*/
    private String sph;

    /**填发日期*/
    private String tfrq;

    /**
     * 地址
     */
    private String dz;

    /**课税数量*/
    private String kssl;

    /**应税项*/
    private String ysx;

    /**已缴或扣除额*/
    private String yjkce;

    /**应纳税额*/
    private String ynse;

    /**本期应补（退）税额*/
    private String ybtse;

    /**填票人*/
    private String tpr;

    /**房源编号*/
    private String fybh;

    /**房屋坐落位置*/
    private String fwzlwz;

    /**房屋面积*/
    private String fwmj;

    /**合同签订日期*/
    private String htqdrq;

    /**申报属性*/
    private String sbsx;

    /**权利人ID*/
    private String qlrid;

    /**核定计税价格*/
    private String hdjsjg;

    /**应纳税额合计*/
    private String ynsehj;

    /**减免税额合计*/
    private String jmsehj;

    /**实际应征合计*/
    private String sjyzhj;

    /**申请人类别*/
    private String sqrlb;

    /**明细种类*/
    private String mxzl;

    /**减免税额*/
    private String jmse;

    /** 顺序号*/
    private String sxh;

    /**拆迁补偿折算减免税款*/
    private String cqbczsjmsk;

    /**增值税小规模纳税人减征比例*/
    private String zzsxgmnsrjzbl;

    /**增值税小规模纳税人减征额*/
    private String zzsxgmnsrjze;

    /**税务状态*/
    private String swzt;

    private String qs;

    private String grsds;

    private String zzs;

    private String total;

    /**是否转让方自开票（本次申报交易是否属于转让方自开票0 否 1 是）*/
    private String sfzrfzkp;

    /**应收税款所属月（当前应收税款所属月份）*/
    private String ysskssyf;

    /**街道乡镇代码*/
    private String jdxzdm;

    /**上次取得房屋交易方式代码*/
    private String scqdfwjyfsdm;

    /**上次取得房屋时间*/
    private String scqdfwsj;

    /**上次取得房屋成本*/
    private String scqdfwcb;

    /**纳税人类型*/
    private String nsrlx;

    /**短信发送状态（0：未发送 1：已发送 2：发送异常）*/
    private String dxfszt;

    /**发票税额*/
    private String fpse;

    /**发票金额*/
    private String fpje;

    /**行政区划*/
    private String xzqhszdm;

    /**取得住房年限代码*/
    private String qdzfnxdm;

    /**税源类型代码GX_YY_ZD_TYPE.ZD_TYPE=SYLX*/
    private String sylxdm;

    /**经办人*/
    private String jbr;

    /**经办人证件种类GX_YY_ZD_TYPE.ZD_TYPE=ZJLX*/
    private String jbrzjzl;

    /**经办人证件号*/
    private String jbrzjh;

    /**转让方承让方关系代码（zd_type表对照）*/
    private String zrfcrfgxdm;

    /**是否征收土地收益金（0：否；1：是）*/
    private String sfzstdsyj;
}
