
package cn.gtmap.hlw.core.dto.sign.create;

import lombok.Data;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 2025/6/5 15:41
 * @description 云签签字顺序计数
 */
@Data
public class SignFlowsIndexDTO {


    /**
     * 权利人index
     */
    private int qlrIndex = 0;
    /**
     * 义务人index
     */
    private int ywrIndex = 0;
    /**
     * 抵押权人index
     */
    private int dyqrIndex = 0;


    /**
     * 根据入参 qlrlx 来对对应字段自增 1
     *
     * @param qlrlx 如果为 1，则 qlrIndex 加 1；
     *              如果为 2，则 ywrIndex 加 1；
     *              如果为 3，则 dyqrIndex 加 1；
     *              其他值不做任何处理。
     */
    public void incrementIndex(String qlrlx) {
        switch (qlrlx) {
            case "1":
                this.qlrIndex++;
                break;
            case "2":
                this.ywrIndex++;
                break;
            case "3":
                this.dyqrIndex++;
                break;
            default:
                // 传入值不在 1~3 范围内，保持原有值不变
                break;
        }
    }

    /**
     * 根据传入的权利人类型 qlrlx，返回对应的索引值
     * @param qlrlx 如果为 1，返回 qlrIndex；
     *               如果为 2，返回 ywrIndex；
     *               如果为 3，返回 dyqrIndex；
     *               其他值则返回 0 或根据需求抛出异常/返回默认值。
     * @return 对应类型的索引值
     */
    public int getIndexByQlrlx(String qlrlx) {
        switch (qlrlx) {
            case "1":
                return this.qlrIndex;
            case "2":
                return this.ywrIndex;
            case "3":
                return this.dyqrIndex;
            default:
                return 0;

        }
    }

}
