package cn.gtmap.hlw.core.dto.fj.download;

import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/26 19:53
 * @description 附件下载DTO
 */
@Data
public class FjDownLoadParamsDTO {
    /**
     * 附件名称
     */
    private String fileName;
    /**
     * 附件id
     */
    private String fjid;
    /**
     * 附件base64
     */
    private String base64;
    /**
     * 附件预览地址
     */
    private String url;

    /**
     * 附件字节
     */
    private byte[] bytes;
    /**
     * 凭据
     */
    private String ticket;
    /**
     * 文件大小
     */
    private String fileLength;

    /**
     * 受理编号
     */
    private String slbh;
    /**
     * 申请类型
     */
    private String sqlx;
    /**
     * pdf转图片base64
     */
    private String pdfToImageBase64;
    /**
     * 附件信息
     */
    private List<FjxxYhzlDTO> fjxxList;
}
