package cn.gtmap.hlw.core.domain.sqxx.model.tz;

import cn.gtmap.hlw.core.annotation.ZdTypeConfig;
import cn.gtmap.hlw.core.constant.dict.ZdTypeConstant;
import lombok.Data;

import java.util.Date;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/30 10:22
 * @description SqxxTzResultModel
 */
@Data
public class SqxxTzResultModel {

    /**
     * slbh
     */
    private String slbh;

    /**
     * 申请类型 gx_yy_sqxx.sqlx
     */
    private String sqlx;

    /**
     * 申请类型名称 gx_yy_zd_sqlx.mc
     */
    private String sqlxmc;

    /**
     * 权利人名称(转移流程qlrmc)
     * 组合流程：gx_yy_zd_sqlx.sfzh=0，gx_yy_zd_sqlx.SFDY=1时，gx_yy_sqxx.qlrmc
     * 非组合流程：gx_yy_zd_sqlx.sfzh=1，gx_yy_zd_sqlx.SFDY=1时，gx_yy_sqxx.qlrmc
     */
    private String qlrmc;

    /**
     * 义务人名称
     * 组合流程：gx_yy_zd_sqlx.sfzh=0，gx_yy_zd_sqlx.SFDY=1时，gx_yy_sqxx.ywrmc
     * 非组合流程：gx_yy_zd_sqlx.sfzh=1，gx_yy_zd_sqlx.SFDY=1时，gx_yy_sqxx.ywrmc
     * 非组合流程：gx_yy_zd_sqlx.sfzh=1，gx_yy_zd_sqlx.SFDY=0时，gx_yy_sqxx.ywrmc
     */
    private String ywrmc;

    /**
     * 抵押权人名称
     * 组合流程：gx_yy_zd_sqlx.sfzh=0，gx_yy_zd_sqlx.SFDY=0时，gx_yy_sqxx.qlrmc
     * 非组合流程：gx_yy_zd_sqlx.sfzh=1，gx_yy_zd_sqlx.SFDY=0时，gx_yy_sqxx.qlrmc
     */
    private String dyqr;

    /**
     * 坐落 gx_yy_sqxx.zl
     */
    private String zl;

    /**
     * 受理状态 gx_yy_sqxx.slzt
     */
    private String slzt;

    /**
     * 受理状态名称 gx_yy_zd_type.zd_type=SLZT gx_yy_zd_type.mc
     */
    @ZdTypeConfig(field = "slzt", tableName = ZdTypeConstant.ZD_TYPE_SLZT, dmToMc = true)
    private String slztmc;

    /**
     * 税务状态 gx_yy_sqxx.swzt
     */
    private String swzt;

    /**
     * 税务状态名称 gx_yy_zd_type.zd_type=swzt gx_yy_zd_type.mc
     */
    @ZdTypeConfig(field = "swzt", tableName = ZdTypeConstant.ZD_TYPE_SWZT, dmToMc = true)
    private String swztmc;

    /**
     * 缴费状态 gx_yy_sqxx.jftz
     */
    private String jfzt;

    /**
     * 缴费状态 gx_yy_zd_type.zd_type=jftz gx_yy_zd_type.mc
     */
    @ZdTypeConfig(field = "jfzt", tableName = ZdTypeConstant.ZD_TYPE_JFZT, dmToMc = true)
    private String jfztmc;

    /**
     * 登记原因 gx_yy_sqxx.djyy
     */
    private String djyy;

    /**
     * 登记原因 gx_yy_sqxx.djyy = gx_yy_djyy.dm ;gx_yy_djyy.mc
     */
    private String djyymc;

    /**
     * 创建时间 gx_yy_sqxx.create_date
     */
    private Date createDate;
}
