package cn.gtmap.hlw.core.dao.yysd;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.yysd.YysdPageQueryDTO;
import cn.gtmap.hlw.core.model.GxYyYysd;

import java.util.List;

/**
 * 预约时段(GxYyYysd)表数据库访问层
 *
 * @author makejava
 * @since 2024-02-19 09:36:38
 */
public interface GxYyYysdDao {

    /**
     * 通过ID查询单条数据
     *
     * @param yysddm 主键
     * @return 实例对象
     */
    GxYyYysd get(String yysddm);

    /**
     * 删除数据
     *
     * @param yysdms 名称
     */
    void deleteByMb(String yysdms);

    /**
     * 删除数据
     *
     * @param yysddm 代码
     */
    void deleteBySd(String yysddm);

    /**
     * 批量保存
     *
     * @param yysdList 实体对象
     * @return 实例对象
     */
    void saveOrUpdateBatchYysd(List<GxYyYysd> yysdList);

    /**
     * 分页查询
     *
     * @param queryDTO
     * @return
     */
    PageInfo<GxYyYysd> page(YysdPageQueryDTO queryDTO);

    /**
     * 下拉框
     *
     * @return
     */
    List<GxYyYysd> getSelected();

    /**
     * 下拉框
     *
     * @param yysddm 名称
     * @return
     */
    List<GxYyYysd> list(String yysddm);

}
