package cn.gtmap.hlw.core.dao.news;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.news.CustomNewsQueryParamsDTO;
import cn.gtmap.hlw.core.model.GxYyCustomNews;

import java.util.List;

/**
 * (GxYyCustomNews)表数据库访问层
 *
 * @author makejava
 * @since 2023-07-03 09:51:35
 */
public interface GxYyCustomNewsDao {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyCustomNews get(String id);

    /**
     * 删除
     *
     * @param id 主键
     * @return 影响行数
     */
    void delete(String id);

    /**
     * 发布
     *
     * @param customNewsQueryParamsDTO 状态
     * @return 影响行数
     */
    void updateStatus(CustomNewsQueryParamsDTO customNewsQueryParamsDTO);

    /**
     * 修改数据
     *
     * @param gxYyCustomNews 实例对象
     * @return 影响行数
     */
    String saveOrUpdateNew(GxYyCustomNews gxYyCustomNews);

    /**
     * 获取数据
     *
     * @param customNewsQueryParamsDTO
     * @return 影响行数
     */
    PageInfo<GxYyCustomNews> page(CustomNewsQueryParamsDTO customNewsQueryParamsDTO);
    /**
     * 查询新闻列表
     * @param
     * @return:List<GxYyCustomNewsPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYyCustomNews> getByParentIsNull();
    /**
     * 根据id集合查询
     * @param parentIdList
     * @return:List<GxYyCustomNewsPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYyCustomNews> listByIds(List<String> parentIdList);
}

