package cn.gtmap.hlw.core.dao.lysj;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.lysj.lysj.LysjListParamsDTO;
import cn.gtmap.hlw.core.dto.lysj.lysj.LysjQueryParamsDTO;
import cn.gtmap.hlw.core.model.GxYyLysj;

import java.util.List;

/**
 * 领域事件(GxYyLysj)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-06 14:39:57
 */
public interface GxYyLysjDao {

    /**
     * 通过ID查询单条数据
     *
     * @param lysjdm 主键
     * @return 实例对象
     */
    GxYyLysj get(String lysjdm);

    /**
     * 新增数据
     *
     * @param gxYyLysj 实例对象
     * @return 影响行数
     */
    void saveLysj(GxYyLysj gxYyLysj);

    /**
     * 删除
     *
     * @param lysjdm 领域事件代码
     * @return 影响行数
     */
    void deleteByLysjdm(String lysjdm);

    /**
     * 修改数据
     *
     * @param gxYyLysj 实例对象
     * @return 影响行数
     */
    void updateLysj(GxYyLysj gxYyLysj);

    /**
     * 领域事件代码信息
     *
     * @param lysjdms
     * @return
     */
    List<GxYyLysj> queryByLysjdmList(List<String> lysjdms);

    /**
     * 领域事件下拉
     *
     * @param queryDTO
     * @return
     */
    List<GxYyLysj> list(LysjListParamsDTO queryDTO);

    List<GxYyLysj> listByLysjdm(List<String> lysjdmList);

    /**
     * 分页查询
     *
     * @param queryDTO
     * @return
     */
    PageInfo<GxYyLysj> page(LysjQueryParamsDTO queryDTO);
    /**
     * 批量保存或更新
     *
     * @param lysjPoList
     * @return
     */
    void saveOrUpdateBatch(List<GxYyLysj> lysjPoList);
    /**
     * 保存或更新
     *
     * @param gxYyLysj
     * @return
     */
    void saveOrUpdate(GxYyLysj gxYyLysj);
}

