package cn.gtmap.hlw.core.dao.jfxm;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.jfxm.SqlxJfxmRelListParamsDTO;
import cn.gtmap.hlw.core.model.GxYySqlxJfxmRel;

import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/12/26
 * @description
 */
public interface GxYySqlxJfxmRelDao {
    /**
     * 根据sqlx查询
     * @param sqlx
     * @return:List<GxYySqlxJfxmRelPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYySqlxJfxmRel> listBySqlx(String sqlx);

    /**
     * 分页查询
     *
     * @param paramsDTO
     * @return
     */
    PageInfo<GxYySqlxJfxmRel> queryPage(SqlxJfxmRelListParamsDTO paramsDTO);

    /**
     * 新增修改
     *
     * @param gxYySqlxJfxmRel
     * @author wangchao
     */
    void saveOrUpdateA(GxYySqlxJfxmRel gxYySqlxJfxmRel);

    /**
     * 删除
     *
     * @param id
     * @author wangchao
     */
    void delete(String id);

    /**
     * 批量保存或更新
     *
     * @param sqlxJfxmRelList
     * @author wangchao
     */
    void saveOrUpdateBatch(List<GxYySqlxJfxmRel> sqlxJfxmRelList);
}
