/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.date;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    public static final String DATE_FORMAT_FULL = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATE_FORMAT_LONG = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_LONG_LYR = "yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss";
    public static final String DATE_FORMAT_SHORT = "yyyy-MM-dd";
    public static final String DATE_FORMAT_HHMMSS = "HHmmss";
    public static final String DATE_FORMAT_HH_MM_SS = "HH:mm:ss";
    public static final String PURE_DATETIME_PATTERN = "yyyyMMddHHmmss";
    public static final String PURE_LONG_DATETIME_PATTERN = "yyyyMMddHHmmssSSS";
    public static final String PURE_DATE_PATTERN = "yyyyMMdd";
    public static final String DATE_FORMAT_YMD = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String DATE_FORMAT_FILE = "yyyy" + File.separator + "MM" + File.separator + "dd";
    static String[] chineseNumbers = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    static String[] chineseUnits = new String[]{"\u5e74", "\u6708", "\u65e5"};

    public static Date date2SimpleDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date date2FormatDate(Date date, String formatStr) {
        String tmp = DateUtils.dateToStr(date, formatStr);
        return DateUtils.strToDate(tmp, formatStr);
    }

    public static String dateToStr(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static String dateToStr(String format) {
        return DateUtils.dateToStr(new Date(), format);
    }

    public static String dateToStr(Date date) {
        return DateUtils.dateToStr(date, DATE_FORMAT_LONG);
    }

    public static String dateToString(Date date) {
        String dateStr = DateUtils.dateToStr(date, "yyyy-MM-dd&HH:mm:ss");
        if (null != dateStr) {
            return dateStr.replace('&', 'T');
        }
        return null;
    }

    public static Date strToDate(String dateStr, String format) {
        if (dateStr == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        try {
            return df.parse(dateStr);
        }
        catch (ParseException e) {
            log.debug("strToDate", (Throwable)e);
            return null;
        }
    }

    public static Date strToDate(String dateStr) {
        return DateUtils.strToDate(dateStr, DATE_FORMAT_LONG);
    }

    public static boolean isDate(String dateStr) {
        if (dateStr == null || !dateStr.matches("^\\d{4}-\\d{2}-\\d{2}$")) {
            return false;
        }
        String[] parts = dateStr.split("-");
        int year = Integer.parseInt(parts[0]);
        int month = Integer.parseInt(parts[1]);
        int day = Integer.parseInt(parts[2]);
        return DateUtils.isValidDate(year, month, day);
    }

    private static boolean isValidDate(int year, int month, int day) {
        if (month < 1 || month > 12 || day < 1 || day > 31) {
            return false;
        }
        if (month == 2) {
            return DateUtils.isLeapYear(year) ? day <= 29 : day <= 28;
        }
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            return day <= 30;
        }
        return true;
    }

    private static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static boolean isDateTime(String dateStr) {
        return dateStr.matches("^((([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)) (([01]{1}\\d{1}|2[0-3]{1}):[0-5]{1}\\d{1}:[0-5]{1}\\d{1})$");
    }

    public static boolean isTime(String dateStr) {
        return dateStr.matches("^([01]{1}\\d{1}|2[0-3]{1}):[0-5]{1}\\d{1}:[0-5]{1}\\d{1}$");
    }

    public static Date getBeforeOrAfterDate(Date dt, int num) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.add(5, num);
        return cal.getTime();
    }

    public static Date getBeforeOrAfterDate(Date dt, int num, int field) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.add(field, num);
        return cal.getTime();
    }

    public static String getBeforeOrAfterDate(String dt, int num) {
        if (DateUtils.isDate(dt)) {
            Date nextDate = DateUtils.getBeforeOrAfterDate(DateUtils.strToDate(dt, DATE_FORMAT_SHORT), num);
            return DateUtils.dateToStr(nextDate, DATE_FORMAT_SHORT);
        }
        if (DateUtils.isDateTime(dt)) {
            Date nextDate = DateUtils.getBeforeOrAfterDate(DateUtils.strToDate(dt, DATE_FORMAT_LONG), num);
            return DateUtils.dateToStr(nextDate, DATE_FORMAT_LONG);
        }
        return null;
    }

    public static String getBeforeOrAfterDate(String dt, int num, String format) {
        Date nextDate = null;
        if (DateUtils.isDate(dt)) {
            nextDate = DateUtils.getBeforeOrAfterDate(DateUtils.strToDate(dt, DATE_FORMAT_SHORT), num);
        } else if (DateUtils.isDateTime(dt)) {
            nextDate = DateUtils.getBeforeOrAfterDate(DateUtils.strToDate(dt, DATE_FORMAT_LONG), num);
        }
        return DateUtils.dateToStr(nextDate, format);
    }

    public static int getDayOfWeek(Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        return cal.get(7);
    }

    public static String getPrintDate() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206", Locale.CHINA);
        return sdf.format(now);
    }

    public static String getPrintDateNYR() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_YMD, Locale.CHINA);
        return sdf.format(now);
    }

    public static String getNowDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        Date date = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat(PURE_DATE_PATTERN);
        String time = sdf.format(date);
        return time;
    }

    public static String systemDateStr() {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_LONG);
        return sdf.format(new Date());
    }

    public static String getMonthByDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return String.valueOf(calendar.get(2) + 1);
    }

    public static Date getDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        return calendar.getTime();
    }

    public static String convertLongToFormattedString(long timestamp, String format) {
        Date date = new Date(timestamp);
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public static String convertDateFormat(String inputDateStr, String inputFormat, String outputFormat) {
        Date date;
        if (StringUtils.isBlank((CharSequence)inputDateStr)) {
            return inputDateStr;
        }
        SimpleDateFormat inputDateFormat = new SimpleDateFormat(inputFormat);
        SimpleDateFormat outputDateFormat = new SimpleDateFormat(outputFormat);
        try {
            date = inputDateFormat.parse(inputDateStr);
        }
        catch (ParseException e) {
            return inputDateStr;
        }
        return outputDateFormat.format(date);
    }

    public static String DateToChinese(Date date) {
        StringBuilder dateStr = new StringBuilder();
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        int year = localDate.getYear();
        int month = localDate.getMonthValue();
        int day = localDate.getDayOfMonth();
        dateStr.append(DateUtils.yearToChinese(year, chineseNumbers)).append(chineseUnits[0]);
        dateStr.append(DateUtils.monthToChinese(month, chineseNumbers)).append(chineseUnits[1]);
        dateStr.append(DateUtils.dayToChinese(day, chineseNumbers)).append(chineseUnits[2]);
        return dateStr.toString();
    }

    private static String yearToChinese(int year, String[] chineseNumbers) {
        StringBuilder result = new StringBuilder();
        while (year > 0) {
            result.insert(0, chineseNumbers[year % 10]);
            year /= 10;
        }
        return result.toString();
    }

    private static String monthToChinese(int month, String[] chineseNumbers) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Invalid month: " + month);
        }
        if (month < 10) {
            return chineseNumbers[month % 10];
        }
        return "\u5341" + (month % 10 != 0 ? chineseNumbers[month % 10] : "");
    }

    private static String dayToChinese(int day, String[] chineseNumbers) {
        if (day < 1 || day > 31) {
            throw new IllegalArgumentException("Invalid day: " + day);
        }
        if (day < 10) {
            return chineseNumbers[day % 10];
        }
        if (day > 9 && day < 20) {
            return "\u5341" + (day % 10 != 0 ? chineseNumbers[day % 10] : "");
        }
        return chineseNumbers[day / 10] + "\u5341" + (day % 10 != 0 ? chineseNumbers[day % 10] : "");
    }
}

