package cn.gtmap.hlw.core.dao.role;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.role.RolePageQueryParamsDTO;
import cn.gtmap.hlw.core.model.GxYyRole;

import java.util.List;

/**
 * (GxYyRole)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-27 17:33:44
 */
public interface GxYyRoleDao {

    /**
     * 根据用户ID去redis里获取角色名称
     *
     * @param ssyhlx
     * @return
     */
    String getRedisRoleNameByRoleId(String ssyhlx);

    /**
     * 通过ID查询单条数据
     *
     * @param roleId 主键
     * @return 实例对象
     */
    GxYyRole get(String roleId);

    /**
     * 获取所有
     *
     * @return 实例对象
     */
    List<GxYyRole> getAll();

    /**
     * 分页查询
     *
     * @param queryDTO 查询条件
     * @return 实例对象
     */
    PageInfo<GxYyRole> queryPage(RolePageQueryParamsDTO queryDTO);

    /**
     * 删除
     *
     * @param roleId
     */
    void delete(String roleId);

    /**
     * 修改数据
     *
     * @param roleIdList 角色id集合
     * @return 影响行数
     */
    List<GxYyRole> getRoleList(List<String> roleIdList);

    /**
     * 保存或更新
     *
     * @param gxYyRolePO 实例对象
     */
    void saveOrUpdateRole(GxYyRole gxYyRolePO);
}

