/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.property;

import cn.hutool.core.io.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesLoadUtil {
    private static final Logger log = LoggerFactory.getLogger(PropertiesLoadUtil.class);
    private static final Pattern PATTERN = Pattern.compile("\\$\\{(.+?)\\}");

    public static void loadProperties() {
        String projectRootPath = System.getProperty("user.dir") + File.separator + "cfg";
        log.info("\u914d\u7f6e\u6587\u4ef6\u76ee\u5f55\u6839\u8def\u5f84\uff1a" + projectRootPath);
        if (!FileUtil.exist((String)projectRootPath)) {
            projectRootPath = PropertiesLoadUtil.class.getClassLoader().getResource("").getPath().substring(1).replace("/", File.separator);
        }
        ArrayList<String> propertiesFilePathList = new ArrayList<String>();
        List fileList = FileUtil.loopFiles((String)projectRootPath);
        if (CollectionUtils.isNotEmpty((Collection)fileList)) {
            for (File file : fileList) {
                String fileName = file.getName();
                if (!StringUtils.endsWith((CharSequence)fileName, (CharSequence)".properties")) continue;
                propertiesFilePathList.add(file.getAbsolutePath());
            }
        }
        if (CollectionUtils.isNotEmpty(propertiesFilePathList)) {
            for (String propertiesPath : propertiesFilePathList) {
                log.info("======\u5373\u5c06\u52a0\u8f7d" + propertiesPath + "\u914d\u7f6e\u6587\u4ef6======");
                PropertiesLoadUtil.load(propertiesPath);
            }
        }
    }

    private static void load(String propertiesPath) {
        Properties properties = new Properties();
        try (BufferedInputStream proStream = new BufferedInputStream(new FileInputStream(propertiesPath));
             BufferedReader proBufferReader = new BufferedReader(new InputStreamReader((InputStream)proStream, StandardCharsets.UTF_8));){
            properties.load(proBufferReader);
            for (String propertyName : properties.stringPropertyNames()) {
                String propertyValue = properties.getProperty(propertyName);
                Matcher matcher = PATTERN.matcher(propertyValue);
                StringBuffer buffer = new StringBuffer();
                while (matcher.find()) {
                    String key = matcher.group(1);
                    String value = properties.getProperty(key);
                    if (value == null) {
                        log.error("Missing value for placeholder: {}", (Object)key);
                    }
                    matcher.appendReplacement(buffer, Matcher.quoteReplacement(value));
                }
                matcher.appendTail(buffer);
                properties.setProperty(propertyName, buffer.toString());
            }
            System.getProperties().putAll((Map<?, ?>)properties);
        }
        catch (IOException e) {
            log.error("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }
}

