package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;


/**
 * 行政区域划分等级表(GxYyZdXzqy)表实体类BO
 *
 * @author makejava
 * @since 2023-05-31 16:38:58
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyZdXzqy implements Serializable {
    private static final long serialVersionUID = -2782803910792450413L;
    /**主键ID*/
    private String id;

    /**行政区域划分等级（1：省，2：市：3：县）*/
    private String dj;

    /**行政区域划分等级*/
    private String dm;

    /**行政区域划分等级_名称*/
    private String mc;

    /**行政区域划分等级_父代码*/
    private String parentDm;

    /**是否禁用（0：使用，1：禁用）*/
    private Integer isDelete;

    /**
     * 项目地址
     */
    private String xmdz;


}

