package cn.gtmap.hlw.core.util.file;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

/**
 * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
 * @version 1.0, 2025/10/20
 * @description
 */
@Slf4j
public class PdfToImageUtils {
    public static String pdfToPic(byte[] fileContent, String wjlx, String pdfExchangeDpi) {
        try (PDDocument document = PDDocument.load(fileContent)) {
            PDFRenderer renderer = new PDFRenderer(document);
            int actSize = document.getNumberOfPages();
            float dpi = 80; // 降低默认DPI
            if (StringUtils.isNotBlank(pdfExchangeDpi)) {
                dpi = Float.parseFloat(pdfExchangeDpi);
            }

            // 逐页处理而不是全部加载到内存
            List<BufferedImage> piclist = new ArrayList<>();
            for (int i = 0; i < document.getNumberOfPages(); ++i) {
                BufferedImage image = renderer.renderImageWithDPI(i, dpi);
                piclist.add(image);

                // 如果页面较多，可以考虑分批处理
                if (piclist.size() >= 10) { // 每10页处理一次
                    byte[] result = pjPic(piclist, wjlx);
                    // 处理结果...
                    piclist.clear(); // 清空列表释放内存
                }
            }

            // 处理剩余页面
            if (!piclist.isEmpty()) {
                byte[] result = pjPic(piclist, wjlx);
                return result == null ? null : Base64.getEncoder().encodeToString(result);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static byte[] pjPic(List<BufferedImage> piclist, String wjlx) {
        if (piclist == null || piclist.size() <= 0) {
            log.info("图片数组为空!");
            return null;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream()) {
            int height = 0, // 总高度
                    width = 0, // 总宽度
                    heightTemp = 0, // 临时的高度 , 或保存偏移高度
                    heightEach = 0, // 临时的高度，主要保存每个高度
                    picNum = piclist.size();// 图片的数量
            File fileImg = null; // 保存读取出的图片
            int[] heightArray = new int[picNum]; // 保存每个文件的高度
            BufferedImage buffer = null; // 保存图片流
            List<int[]> imgRGB = new ArrayList<int[]>(); // 保存所有的图片的RGB
            int[] imgRGBTemp; // 保存一张图片中的RGB数据
            for (int i = 0; i < picNum; i++) {
                buffer = piclist.get(i);
                heightArray[i] = heightTemp = buffer.getHeight();// 图片高度
                if (i == 0) {
                    width = buffer.getWidth();// 图片宽度
                }
                height += heightTemp; // 获取总高度
                imgRGBTemp = new int[width * heightTemp];// 从图片中读取RGB
                imgRGBTemp = buffer.getRGB(0, 0, width, heightTemp, imgRGBTemp, 0, width);
                imgRGB.add(imgRGBTemp);
            }
            heightTemp = 0; // 设置偏移高度为0
            // 生成新图片
            BufferedImage imageResult = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
            for (int i = 0; i < picNum; i++) {
                heightEach = heightArray[i];
                if (i != 0) {
                    heightTemp += heightEach;
                } // 计算偏移高度
                imageResult.setRGB(0, heightTemp, width, heightEach, imgRGB.get(i), 0, width); // 写入流中
            }
            //ImageIO.write(imageResult, "jpg", outFile);// 写图片
            ImageIO.write(imageResult, wjlx, out);
            return out.toByteArray();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}
