package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqxxDyxx;

import java.util.List;

/**
 * (GxYySqxxDyxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:45
 */
public interface GxYySqxxDyxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param dyid 主键
     * @return 实例对象
     */
    GxYySqxxDyxx get(String dyid);

    /**
     * 通过申请ID查询数据集合
     *
     * @param sqid 申请ID
     * @return 实例对象
     */
    List<GxYySqxxDyxx> list(String sqid);

    /**
     * 通过slbh查询数据集合
     *
     * @param slbh 受理编号
     * @return 实例对象
     */
    List<GxYySqxxDyxx> getBySlbh(String slbh);

    /**
     * 获取数据
     *
     * @param sqid 申请ID
     * @return 实例对象
     */
    GxYySqxxDyxx getBySqid(String sqid);

    /**
     * 获取数据
     *
     * @param sqid 申请ID
     * @param slbh 受理编号
     * @return 实例对象
     */
    GxYySqxxDyxx getByParams(String sqid, String slbh);

    /**
     * 新增数据
     *
     * @param gxYySqxxDyxx 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxDyxx gxYySqxxDyxx);

    /**
     * 修改数据
     *
     * @param gxYySqxxDyxx 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxDyxx gxYySqxxDyxx);

    /**
     * 修改数据，策略：Ignored，null值也会被更新
     *
     * @param gxYySqxxDyxx 实例对象
     * @return 影响行数
     */
    void updateIgnored(GxYySqxxDyxx gxYySqxxDyxx);

    /**
     * 新增或修改数据
     *
     * @param gxYySqxxDyxx 实例对象
     * @return 影响行数
     */
    void saveOrUpdate(GxYySqxxDyxx gxYySqxxDyxx);

    /**
     * 通过sqidList查询单条数据
     *
     * @param sqidList 主键
     * @return 实例对象
     */
    List<GxYySqxxDyxx> list(List<String> sqidList);

    /**
     * 通过sqidList删除数据
     *
     * @param sqidList 实例对象
     * @return 影响行数
     */
    int deleteBySqidList(List<String> sqidList);

    /**
     * 批量保存或更新数据
     *
     * @param gxYySqxxDyxxList 实例对象
     * @return 影响行数
     */
    void saveOrUpdateBatch(List<GxYySqxxDyxx> gxYySqxxDyxxList);

    /**
     * 根据slbh删除数据
     *
     * @param slbh 受理编号
     * @return 影响行数
     */
    void delete(String slbh);

    /**
     * 根据dyid删除
     *
     * @param dyid
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteById(String dyid);

    /**
     * @param sqid
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteBySqid(String sqid);
    /**
     * 批量保存
     * @param sqxxDyxxList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void saveBatch(List<GxYySqxxDyxx> sqxxDyxxList);

    /**
     * 通过主键集合查询数据
     *
     * @param dyidList 主键集合
     * @return 实例对象
     */
    List<GxYySqxxDyxx> listByDyid(List<String> dyidList);
}

