package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 在线申请--会签(GxYySqxxHq)表实体类BO
 *
 * @author makejava
 * @since 2023-05-31 14:14:46
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYySqxxHq implements Serializable {

    private static final long serialVersionUID = 5521907176306757831L;

    private String hqid;

    /**
     * 受理编号
     */
    private String slbh;

    /**
     * 用户userid
     */
    private String userGuid;

    /**
     * 短信发送结果(0：已发送，1：未发送，2：发送失败)
     */
    private Integer smsSendStatus;

    /**
     * 权利人ID((gx_yy_qlr.qlrid))
     */
    private String qlrid;

    /**
     * 是否认证（0:是 认证通过，1：否 未认证，2:驳回,3:待认证-银行认证通过后个人核验,4:待认证-个人核验后银行核验）
     */
    private Integer sfrz;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 认证时间
     */
    private Date rzTime;

    /**
     * 法定代表人或负责人ID
     */
    private String fddbrhfzrid;

    /**
     * 是否签章（0:未签章，1:签章完成;2:签章失败 3:拒签）
     */
    private String sfqz;

    /**
     * 签章时间
     */
    private Date qzTime;

    /**
     * 签章用户userid
     */
    private String qzUserGuid;

    /**
     * 买卖双方税费确认（0:否，1:是）
     */
    private String sfqr;

    /**
     * 是否查看税费清单界面（0:否，1:是）
     */
    private String sfcksfqd;

    /**
     * 签章原因描述（拒签或失败时，附加的原因描述）
     */
    private String qzyyms;

    /**
     * 代理人ID(gx_yy_qlr.dlrid)
     */
    private String dlrid;

    /**
     * 监护人ID(gx_yy_qlr_jhr.jhrid)
     */
    private String jhrid;

    /**
     * 认证用户userid
     */
    private String rzUserGuid;

    /**
     * 用户类型(0：权利人，1:权利人夫妻)
     */
    private String yhlx;


}

